package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AgencyClientRelationsBind;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AgencyClientRelationsClientArchived;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AgencyClientRelationsRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import java.util.List;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.AgencyClientRelations.AGENCY_CLIENT_RELATIONS;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.Clients.CLIENTS;

/**
 * Created by alexteut on 27.09.16.
 */
public class AgencyClientRelationsSteps extends BasePpcSteps {
    @Step("DB: создание записи в таблице ppc.agency_client_relations")
    public void add(AgencyClientRelationsRecord record) {
        exec(db -> db.insertInto(AGENCY_CLIENT_RELATIONS)
                .set(record)
                .execute());
    }

    @Step("DB: добавление записи в таблицу ppc.agency_client_relations для clientID={0}, agencyClientID={1}, bind={2}, clientArchived={3}, clientDescription={4}")
    public void add(Long clientID, Long agencyClientID, AgencyClientRelationsBind bind, AgencyClientRelationsClientArchived clientArchived, String clientDescription) {
        run(db -> db.insertInto(AGENCY_CLIENT_RELATIONS)
                .set(AGENCY_CLIENT_RELATIONS.CLIENT_CLIENT_ID, clientID)
                .set(AGENCY_CLIENT_RELATIONS.AGENCY_CLIENT_ID, agencyClientID)
                .set(AGENCY_CLIENT_RELATIONS.BIND, bind)
                .set(AGENCY_CLIENT_RELATIONS.CLIENT_ARCHIVED, clientArchived)
                .set(AGENCY_CLIENT_RELATIONS.CLIENT_DESCRIPTION, clientDescription)
                .execute());
    }

    @Step("DB: получение записи из таблицы ppc.agency_client_relations по ClientID:{0}")
    public AgencyClientRelationsRecord get(Long clientID, Long agencyClientID) {
        return exec(db -> db.selectFrom(AGENCY_CLIENT_RELATIONS)
                .where(      AGENCY_CLIENT_RELATIONS.CLIENT_CLIENT_ID.eq(clientID)
                        .and(AGENCY_CLIENT_RELATIONS.AGENCY_CLIENT_ID.eq(agencyClientID)))
                .fetchOne());
    }

    @Step("DB: получение записи из таблицы ppc.agency_client_relations по ClientID:{0}")
    public List<AgencyClientRelationsRecord> getRelationsByClientId(Long clientID) {
        return exec(db -> db.selectFrom(AGENCY_CLIENT_RELATIONS)
                .where(AGENCY_CLIENT_RELATIONS.CLIENT_CLIENT_ID.eq(clientID))
                .fetch());
    }

    @Step("DB: получение записи из таблицы ppc.agency_client_relations по AgencyClientID:{0}")
    public List<AgencyClientRelationsRecord> getRelationsByAgencyId(Long agencyClientID) {
        return exec(db -> db.selectFrom(AGENCY_CLIENT_RELATIONS)
                .where(AGENCY_CLIENT_RELATIONS.AGENCY_CLIENT_ID.eq(agencyClientID))
                .fetch());
    }

    @Step("DB: обновление записи в таблице ppc.agency_client_relations")
    public void update(AgencyClientRelationsRecord agencyClientRelations) {
        run(db -> db.update(AGENCY_CLIENT_RELATIONS)
                .set(agencyClientRelations)
                .where(      AGENCY_CLIENT_RELATIONS.CLIENT_CLIENT_ID.eq(agencyClientRelations.getClientClientId())
                        .and(AGENCY_CLIENT_RELATIONS.AGENCY_CLIENT_ID.eq(agencyClientRelations.getAgencyClientId()))
                ).execute()
        );
    }

    @Step("DB: удаление записи в таблице ppc.agency_client_relations для ClientID:{0}")
    public void deleteByClient(Long clientId) {
        exec(db -> db.deleteFrom(AGENCY_CLIENT_RELATIONS)
                .where(AGENCY_CLIENT_RELATIONS.CLIENT_CLIENT_ID.eq(clientId))
                .execute());
    }

    @Step("DB: удаление записи в таблице ppc.agency_client_relations для AgencyClientID:{0}")
    public void deleteByAgency(Long agencyClientId) {
        exec(db -> db.deleteFrom(AGENCY_CLIENT_RELATIONS)
                .where(AGENCY_CLIENT_RELATIONS.AGENCY_CLIENT_ID.eq(agencyClientId))
                .execute());
    }

    @Step("DB: удаление записи в таблице ppc.agency_client_relations для AgencyClientID:{0}")
    public void delete(Long agencyClientId) {
        exec(db -> db.deleteFrom(AGENCY_CLIENT_RELATIONS)
                .where(AGENCY_CLIENT_RELATIONS.AGENCY_CLIENT_ID.eq(agencyClientId))
                .execute());
    }


    @Step("DB: обновление записи в таблице ppc.agency_client_relations")
    public void setArchivedByClient(Long clientId, AgencyClientRelationsClientArchived isArchived) {
        run(db -> db.update(AGENCY_CLIENT_RELATIONS)
                .set(AGENCY_CLIENT_RELATIONS.CLIENT_ARCHIVED, isArchived)
                .where(AGENCY_CLIENT_RELATIONS.CLIENT_CLIENT_ID.eq(clientId))
                .execute());
    }

    @Step("DB: обновление записи в таблице ppc.agency_client_relations")
    public void setArchivedByClient(Long clientId, AgencyClientRelationsClientArchived isArchived, Long exceptAgencyId) {
        run(db -> db.update(AGENCY_CLIENT_RELATIONS)
                .set(AGENCY_CLIENT_RELATIONS.CLIENT_ARCHIVED, isArchived)
                .where(AGENCY_CLIENT_RELATIONS.CLIENT_CLIENT_ID.eq(clientId)
                .and(AGENCY_CLIENT_RELATIONS.AGENCY_CLIENT_ID.ne(exceptAgencyId)))
                .execute());
    }

    @Step("DB: обновление записи в таблице ppc.agency_client_relations")
    public void setActiveByClient(Long clientId, AgencyClientRelationsBind isBind) {
        run(db -> db.update(AGENCY_CLIENT_RELATIONS)
                .set(AGENCY_CLIENT_RELATIONS.BIND, isBind)
                .where(AGENCY_CLIENT_RELATIONS.CLIENT_CLIENT_ID.eq(clientId))
                .execute());
    }

    @Step("DB: обновление записи в таблице ppc.agency_client_relations")
    public void setActiveByClient(Long clientId, AgencyClientRelationsBind isBind, Long exceptAgencyId) {
        run(db -> db.update(AGENCY_CLIENT_RELATIONS)
                .set(AGENCY_CLIENT_RELATIONS.BIND, isBind)
                .where(AGENCY_CLIENT_RELATIONS.CLIENT_CLIENT_ID.eq(clientId)
                        .and(AGENCY_CLIENT_RELATIONS.AGENCY_CLIENT_ID.ne(exceptAgencyId)))
                .execute());
    }
}
