package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AgencyOptionsRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.AGENCY_OPTIONS;

public class AgencyOptionsSteps extends BasePpcSteps {
    @Step("DB: добавление или обновление записи в таблицу ppc.agency_options для agencyOptionsRecord={1}")
    public void add(AgencyOptionsRecord agencyOptionsRecord) {
        run(db -> db.insertInto(AGENCY_OPTIONS,
                AGENCY_OPTIONS.CLIENTID, AGENCY_OPTIONS.ALLOW_CLIENTS_WITHOUT_WALLET,
                AGENCY_OPTIONS.DEFAULT_CLIENTS_WITH_WALLET, AGENCY_OPTIONS.PREFERRED_DEAL_FEE_PERCENT)
                .values(agencyOptionsRecord.getClientid(), agencyOptionsRecord.getAllowClientsWithoutWallet(),
                        agencyOptionsRecord.getDefaultClientsWithWallet(),
                        agencyOptionsRecord.getPreferredDealFeePercent())
                .onDuplicateKeyUpdate()
                .set(AGENCY_OPTIONS.ALLOW_CLIENTS_WITHOUT_WALLET, agencyOptionsRecord.getAllowClientsWithoutWallet())
                .set(AGENCY_OPTIONS.DEFAULT_CLIENTS_WITH_WALLET, agencyOptionsRecord.getDefaultClientsWithWallet())
                .set(AGENCY_OPTIONS.PREFERRED_DEAL_FEE_PERCENT, agencyOptionsRecord.getPreferredDealFeePercent())
                .execute()
        );
    }

    @Step("DB: разрешение агентству {1} создавать клиентов без ОС")
    public void allowCreateClientsWithoutWallet(Long agencyId) {
        run(db -> db.update(AGENCY_OPTIONS)
                .set(AGENCY_OPTIONS.ALLOW_CLIENTS_WITHOUT_WALLET, 1)
                .where(AGENCY_OPTIONS.CLIENTID.eq(agencyId))
                .execute()
        );
    }

    @Step("DB: запрет агентству {1} создавать клиентов без ОС")
    public void banCreateClientsWithoutWallet(Long agencyId) {
        run(db -> db.update(AGENCY_OPTIONS)
                .set(AGENCY_OPTIONS.ALLOW_CLIENTS_WITHOUT_WALLET, 0)
                .where(AGENCY_OPTIONS.CLIENTID.eq(agencyId))
                .execute()
        );
    }
}
