package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.records.ApiDomainStatRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcDictSteps;
import ru.yandex.qatools.allure.annotations.Step;

import java.sql.Date;
import java.util.List;

import static ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.ApiDomainStat.API_DOMAIN_STAT;

public class ApiDomainStatSteps extends BasePpcDictSteps {

    @Step("DB: чтение из таблицы в ppcdict.api_domain_stat, domains: {0}")
    public List<ApiDomainStatRecord> getApiDomainStats(String... domains) {
        return exec(db ->
                db.selectFrom(API_DOMAIN_STAT)
                        .where(API_DOMAIN_STAT.FILTER_DOMAIN.in(domains))
                        .fetch());
    }

    @Step("DB: запись в таблицу ppcdict.api_domain_stat")
    public void createApiDomainStat(ApiDomainStatRecord apiDomainStat) {
        exec(db -> db.insertInto(API_DOMAIN_STAT)
                .set(apiDomainStat)
                .execute());
    }

    @Step("DB: удаление из таблицы ppcdict.api_domain_stat, domain: {0}, stat_date: {1}")
    public void deleteApiDomainStat(String domain, Date statDate) {
        exec(db -> db.deleteFrom(API_DOMAIN_STAT)
                .where(API_DOMAIN_STAT.FILTER_DOMAIN.eq(domain).and(API_DOMAIN_STAT.STAT_DATE.eq(statDate)))
                .execute());
    }

    @Step("DB: удаление из таблицы ppcdict.api_domain_stat, domain: {0}")
    public void deleteApiDomainStat(String domain) {
        exec(db -> db.deleteFrom(API_DOMAIN_STAT)
                .where(API_DOMAIN_STAT.FILTER_DOMAIN.eq(domain))
                .execute());
    }

}
