package ru.yandex.autotests.direct.db.steps;


import java.util.Optional;

import ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.records.ApiFinanceTokensRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcDictSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.USERS;
import static ru.yandex.autotests.direct.db.models.jooq.ppcdict.Tables.API_FINANCE_TOKENS;


public class ApiFinanceTokensSteps extends BasePpcDictSteps {
    @Step("DB: получение записи в таблице ppcdict.api_finance_tokens по uid: {0}")
    public Optional<ApiFinanceTokensRecord> get(long uid) {
        return exec(db -> db.selectFrom(API_FINANCE_TOKENS)
                .where(API_FINANCE_TOKENS.UID.eq(uid))
                .fetchOptional()
        );
    }

    @Step("DB: получение поля master_token из таблицы ppcdict.api_finance_tokens по логину: {0}")
    public String getMasterToken(String login) {
        long uid = exec(db -> db.selectFrom(USERS)
                .where(USERS.LOGIN.eq(login))
                .fetchOne(USERS.UID)
        );
        return exec(db -> db.selectFrom(API_FINANCE_TOKENS)
                .where(API_FINANCE_TOKENS.UID.eq(uid))
                .fetchOne(API_FINANCE_TOKENS.MASTER_TOKEN)
        );
    }
}
