package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AutobudgetCpaAlertsRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.AUTOBUDGET_CPA_ALERTS;

public class AutoBudgetCpaAlertsSteps extends BasePpcSteps {
    @Step("DB: добавление записи в таблицу ppc.autobudget_cpa_alerts")
    public void addOrUpdateAutoBudgetCpaAlertsRecord(AutobudgetCpaAlertsRecord autoBudgetRecord) {
        run(db -> db.insertInto(AUTOBUDGET_CPA_ALERTS)
                .set(autoBudgetRecord)
                .onDuplicateKeyUpdate()
                .set(autoBudgetRecord)
                .execute()
        );
    }

    @Step("DB: удаление записи из таблицы ppc.autobudget_cpa_alerts cid: {0}")
    public void deleteAutoBudgetCpaAlertsRecord(Long cid) {
        run(db -> db.deleteFrom(AUTOBUDGET_CPA_ALERTS)
                .where(AUTOBUDGET_CPA_ALERTS.CID.eq(cid))
                .execute()
        );
    }

    @Step("DB: получение записи из таблицы ppc.autobudget_cpa_alerts (cid = {0})")
    public AutobudgetCpaAlertsRecord getAutobudgetCpaAlertsRecord(Long cid) {
        return exec(db ->
                db.selectFrom(AUTOBUDGET_CPA_ALERTS)
                        .where(AUTOBUDGET_CPA_ALERTS.CID.eq(cid))
                        .fetchAny());
    }
}
