package ru.yandex.autotests.direct.db.steps;

import java.math.BigInteger;

import ru.yandex.autotests.direct.db.steps.base.BasePpcDictSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppcdict.Tables.INC_ADGROUP_ADDITIONAL_TARGETINGS;
import static ru.yandex.autotests.direct.db.models.jooq.ppcdict.Tables.INC_BANNER_ADDITIONAL_HREFS_ID;
import static ru.yandex.autotests.direct.db.models.jooq.ppcdict.Tables.INC_CAMPAIGNS_PROMOTIONS_IDS;
import static ru.yandex.autotests.direct.db.models.jooq.ppcdict.Tables.INC_CLIENTS_RELATIONS_ID;
import static ru.yandex.autotests.direct.db.models.jooq.ppcdict.Tables.INC_CLIENT_DIALOG_ID;
import static ru.yandex.autotests.direct.db.models.jooq.ppcdict.Tables.INC_CONTENT_PROMOTION_ID;
import static ru.yandex.autotests.direct.db.models.jooq.ppcdict.Tables.INC_MOBILE_APP_TRACKER_ID;
import static ru.yandex.autotests.direct.db.models.jooq.ppcdict.Tables.INC_MOBILE_GOALS_ID;
import static ru.yandex.autotests.direct.db.models.jooq.ppcdict.Tables.INC_MODERATE_BANNER_PAGE_ID;
import static ru.yandex.autotests.direct.db.models.jooq.ppcdict.Tables.INC_RET_ID;
import static ru.yandex.autotests.direct.db.models.jooq.ppcdict.Tables.INC_REVERSE_CLIENTS_RELATIONS_ID;
import static ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.IncAdditionsItemId.INC_ADDITIONS_ITEM_ID;
import static ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.IncBannerCreativeId.INC_BANNER_CREATIVE_ID;
import static ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.IncExperimentId.INC_EXPERIMENT_ID;
import static ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.IncFeedId.INC_FEED_ID;
import static ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.IncHierarchicalMultiplierId.INC_HIERARCHICAL_MULTIPLIER_ID;
import static ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.IncImageId.INC_IMAGE_ID;
import static ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.IncMobileAppId.INC_MOBILE_APP_ID;
import static ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.IncMobileContentId.INC_MOBILE_CONTENT_ID;
import static ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.IncMwId.INC_MW_ID;
import static ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.IncPerfFilterId.INC_PERF_FILTER_ID;
import static ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.IncPhid.INC_PHID;
import static ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.IncPixelId.INC_PIXEL_ID;
import static ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.IncResourceId.INC_RESOURCE_ID;
import static ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.ShardIncRetCondId.SHARD_INC_RET_COND_ID;

/**
 * Набор степов для генерации id-шников, имеющий сквозной автоинкремент по всем шардам.
 * Для генерации используются соответствующие таблицы в базе ppcdict.
 */
public class AutoIncSteps extends BasePpcDictSteps {

    /**
     * Возвращает новое значение feed_id для использования в качестве PRIMARY KEY для записи ppc.feeds.
     * Получается с использованием авто-инкрементной таблицы inc_feed_id.
     *
     * @return следующее значение авто-инкремента по feed_id
     */
    @Step("Генерация нового автоинкрементного значения feed_id")
    public Long getNewFeedId() {
        return exec(db -> db.insertInto(INC_FEED_ID)
                .defaultValues()
                .returning()
                .fetchOne()
        ).getFeedId();
    }

    /**
     * Возвращает новое значение experiment_id для использования в качестве PRIMARY KEY для записи ppc.experiments.
     * Получается с использованием авто-инкрементной таблицы inc_experiment_id.
     *
     * @return следующее значение авто-инкремента по experiment_id
     */
    @Step("Генерация нового автоинкрементного значения experiment_id")
    public Long getNewExperimentId() {
        return exec(db -> db.insertInto(INC_EXPERIMENT_ID)
                .defaultValues()
                .returning()
                .fetchOne()
        ).getExperimentId();
    }

    /**
     * Возвращает новое значение image_id для использования в качестве PRIMARY KEY для записи ppc.images.
     * Получается с использованием авто-инкрементной таблицы inc_image_id.
     *
     * @return следующее значение авто-инкремента по image_id
     */
    @Step("Генерация нового автоинкрементного значения image_id")
    public Long getNewImageId() {
        return exec(db -> db.insertInto(INC_IMAGE_ID)
                .defaultValues()
                .returning()
                .fetchOne()
        ).getImageId();
    }

    /**
     * Возвращает новое значение mobile_content_id для использования в качестве PRIMARY KEY для записи ppc
     * .mobile_content.
     * Получается с использованием авто-инкрементной таблицы inc_mobile_content_id.
     *
     * @return следующее значение авто-инкремента по mobile_content_id
     */
    @Step("Генерация нового автоинкрементного значения mobile_content_id")
    public Long getNewMobileContentId() {
        return exec(db -> db.insertInto(INC_MOBILE_CONTENT_ID)
                .defaultValues()
                .returning()
                .fetchOne()
        ).getMobileContentId();
    }

    @Step("Генерация нового автоинкрементного значения mobile_app_id")
    public Long getNewMobileAppId() {
        return exec(db -> db.insertInto(INC_MOBILE_APP_ID)
                .defaultValues()
                .returning()
                .fetchOne()
        ).getMobileAppId();
    }

    @Step("Генерация нового автоинкрементного значения mobile_app_tracker_id")
    public Long getNewMobileAppTrackerId() {
        return exec(db -> db.insertInto(INC_MOBILE_APP_TRACKER_ID)
                .defaultValues()
                .returning()
                .fetchOne()
        ).getMobileAppTrackerId();
    }

    @Step("Генерация нового автоинкрементного значения mobile_goal_id")
    public Long getNewMobileGoalId() {
        return exec(db -> db.insertInto(INC_MOBILE_GOALS_ID)
                .defaultValues()
                .returning()
                .fetchOne()
        ).getGoalId();
    }

    @Step("Генерация нового автоинкрементного значения client_dialog_id")
    public Long getNewClientDialogId() {
        return exec(db -> db.insertInto(INC_CLIENT_DIALOG_ID)
                .defaultValues()
                .returning()
                .fetchOne()
        ).getClientDialogId();
    }

    /**
     * Возвращает новое значение perf_filter_id для использования в качестве PRIMARY KEY для записи ppc.perf_filter.
     * Получается с использованием авто-инкрементной таблицы inc_perf_filter_id.
     *
     * @return следующее значение авто-инкремента по perf_filter_id
     */
    @Step("Генерация нового автоинкрементного значения perf_filter")
    public Long getNewPerfFilterId() {
        return exec(db -> db.insertInto(INC_PERF_FILTER_ID)
                .defaultValues()
                .returning()
                .fetchOne()
        ).getPerfFilterId();
    }

    /**
     * Возвращает новое значение banner_creative_id для использования в записи ppc.banners_performance.
     * Получается с использованием авто-инкрементной таблицы inc_banner_creative_id.
     *
     * @return следующее значение авто-инкремента по banner_creative_id
     */
    @Step("Генерация нового автоинкрементного значения banner_creative_id")
    public Long getNewBannerCreativeId() {
        return exec(db -> db.insertInto(INC_BANNER_CREATIVE_ID)
                .defaultValues()
                .returning()
                .fetchOne()
        ).getBannerCreativeId();
    }


    /**
     * Возвращает новое значение mw_id для использования в записи ppc.minus_words.
     * Получается с использованием авто-инкрементной таблицы inc_mw_id.
     *
     * @return следующее значение авто-инкремента по inc_mw_id
     */
    public Long getNewMwId() {
        return exec(db -> db.insertInto(INC_MW_ID)
                .defaultValues()
                .returning()
                .fetchOne()
        ).getMwId();
    }

    /**
     * Возвращает новое значение additions_item_id для использования в качестве PRIMARY KEY для записи
     * ppc.additions_item_disclaimers или additions_item_callouts.
     * Получается с использованием авто-инкрементной таблицы inc_additions_item_id.
     *
     * @return следующее значение авто-инкремента по feed_id
     */
    @Step("Генерация нового автоинкрементного значения additions_item_id")
    public Long getNewAdditionsItemId() {
        return exec(db -> db.insertInto(INC_ADDITIONS_ITEM_ID)
                .defaultValues()
                .returning()
                .fetchOne()
        ).getAdditionsItemId();
    }

    /**
     * Возвращает новое значение resource_id для использования в записи ppc.banner_resources.
     * Получается с использованием авто-инкрементной таблицы inc_resource_id.
     *
     * @return следующее значение авто-инкремента по inc_resource_id
     */
    public Long getNewResourceId() {
        return exec(db -> db.insertInto(INC_RESOURCE_ID)
                .defaultValues()
                .returning()
                .fetchOne()
        ).getResourceId();
    }

    /**
     * Возвращает новое значение bid_id для использования в записях ppc.bids, ppc.bid_base
     * Получается с использованием авто-инкрементной таблицы inc_phid.
     *
     * @return следующее значение авто-инкремента по inc_phid
     */
    public BigInteger getNewBidId() {
        return exec(db -> db.insertInto(INC_PHID)
                .defaultValues()
                .returning()
                .fetchOne()
        ).getPhid();
    }

    /**
     * Возвращает новое значение ret_cond_id для использования в качестве PRIMARY KEY для записи ppc
     * .retargeting_conditions.
     * Получается с использованием авто-инкрементной таблицы shard_inc_ret_cond_id.
     *
     * @return следующее значение авто-инкремента по shard_inc_ret_cond_id
     */
    @Step("Генерация нового автоинкрементного значения retargeting_conditions")
    public Long getNewRetargetingConditionId(Long clientId) {
        return exec(db -> db.insertInto(SHARD_INC_RET_COND_ID)
                .set(SHARD_INC_RET_COND_ID.CLIENTID, clientId)
                .returning()
                .fetchOne()
        ).getRetCondId();
    }

    /**
     * Возвращает новое значение ret_id для использования в качестве PRIMARY KEY для записи ppc.bids_retargeting.
     * Получается с использованием авто-инкрементной таблицы inc_ret_id.
     *
     * @return следующее значение авто-инкремента по inc_ret_id
     */
    @Step("Генерация нового автоинкрементного значения retargeting")
    public Long getNewRetargetingId() {
        return exec(db -> db.insertInto(INC_RET_ID)
                .defaultValues()
                .returning()
                .fetchOne()
        ).getRetId();
    }

    /**
     * Возвращает новое значение hierarchical_multiplier_id для использования в записи ppc.hierarchical_multipliers.
     * Получается с использованием авто-инкрементной таблицы inc_hierarchical_multiplier_id.
     *
     * @return следующее значение авто-инкремента по inc_hierarchical_multiplier_id
     */
    public BigInteger getNewHierarchicalMultipliersId() {
        return exec(db -> db.insertInto(INC_HIERARCHICAL_MULTIPLIER_ID)
                .defaultValues()
                .returning()
                .fetchOne()
        ).getHierarchicalMultiplierId();
    }

    /**
     * Возвращает новое значение pixel_id для использования в записи ppc.pixels.
     * Получается с использованием авто-инкрементной таблицы inc_pixel_id.
     *
     * @return следующее значение авто-инкремента по inc_pixel_id
     */
    @Step("Генерация нового автоинкрементного значения inc_pixel_id")
    public Long getNewPixelId() {
        return exec(db -> db.insertInto(INC_PIXEL_ID)
                .defaultValues()
                .returning()
                .fetchOne()
        ).getPixelId();
    }

    /**
     * Возвращает новое значение moderate_banner_page_id для использования в записи ppc.moderate_banner_pages.
     * Получается с использованием авто-инкрементной таблицы inc_moderate_banner_page_id.
     *
     * @return следующее значение авто-инкремента по inc_moderate_banner_page_id
     */
    @Step("Генерация нового автоинкрементного значения inc_moderate_banner_page_id")
    public Long getNewModerateBannerPageId() {
        return exec(db -> db.insertInto(INC_MODERATE_BANNER_PAGE_ID)
                .defaultValues()
                .returning()
                .fetchOne()
        ).getModerateBannerPageId();
    }

    @Step("Генерация нового значения inc_adgroup_additional_targetings")
    public Long getNextAdgroupAdditionalTargetingId() {
        return exec(
                db -> db.insertInto(INC_ADGROUP_ADDITIONAL_TARGETINGS)
                        .defaultValues()
                        .returning()
                        .fetchOne()
        ).getId();
    }

    /**
     * Возвращает новое значение content_promotion_id для использования в записи ppc.content_promotion.
     * Получается с использованием авто-инкрементной таблицы inc_content_promotion_id.
     *
     * @return следующее значение авто-инкремента по inc_content_promotion_id
     */
    @Step("Генерация нового автоинкрементного значения inc_content_promotion_id")
    public Long getNewContentPromotionId() {
        return exec(db -> db.insertInto(INC_CONTENT_PROMOTION_ID)
                .defaultValues()
                .returning()
                .fetchOne()
        ).getContentPromotionId();
    }

    /**
     * Возвращает новое значение href_id для использования в записи ppc.banner_additional_hrefs.
     * Получается с использованием авто-инкрементной таблицы inc_banner_additional_hrefs_id.
     *
     * @return следующее значение авто-инкремента по inc_banner_additional_hrefs_id
     */
    @Step("Генерация нового автоинкрементного значения inc_banner_additional_hrefs_id")
    public Long getNewBannerAdditionalHrefsId() {
        return exec(db -> db.insertInto(INC_BANNER_ADDITIONAL_HREFS_ID)
                .defaultValues()
                .returning()
                .fetchOne()
        ).getHrefId();
    }

    /**
     * Возвращает новое значение promotion_id для использования в записи ppc.campaigns_promotions.
     * Получается с использованием авто-инкрементной таблицы inc_campaigns_promotions_id.
     *
     * @return следующее значение авто-инкремента по inc_campaigns_promotions_id
     */
    @Step("Генерация нового автоинкрементного значения inc_campaigns_promotions_id")
    public Long getNewCampaignsPromotionId() {
        return exec(db -> db.insertInto(INC_CAMPAIGNS_PROMOTIONS_IDS)
                .defaultValues()
                .returning()
                .fetchOne()
        ).getPromotionId();
    }

    @Step("Генерация нового значения inc_clients_relation_id")
    public Long getNextClientsRelationId() {
        return exec(
                db -> db.insertInto(INC_CLIENTS_RELATIONS_ID)
                        .defaultValues()
                        .returning()
                        .fetchOne()
        ).getRelationId();
    }

    @Step("Генерация нового значения inc_reverse_clients_relation_id")
    public Long getNextReverseClientsRelationId() {
        return exec(
                db -> db.insertInto(INC_REVERSE_CLIENTS_RELATIONS_ID)
                        .defaultValues()
                        .returning()
                        .fetchOne()
        ).getReverseRelationId();
    }

}
