package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AutopaySettingsPaymethodType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AutopaySettingsRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import java.math.BigDecimal;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.AutopaySettings.AUTOPAY_SETTINGS;


/*
* todo javadoc
*/
public class AutopaySettingsSteps extends BasePpcSteps {

    @Step("DB: чтение записи из таблицы ppc.autopay_settings")
    public AutopaySettingsRecord getAutopaySettings(Long walletCid) {
        return exec(db -> db.selectFrom(AUTOPAY_SETTINGS)
                .where(AUTOPAY_SETTINGS.WALLET_CID.eq(walletCid))
                .fetchOne()
        );
    }

    @Step("DB: изменение записи в таблице ppc.autopay_settings")
    public void updateAutopaySettings(AutopaySettingsRecord autopaySettings) {
        run(db -> db.update(AUTOPAY_SETTINGS)
                .set(autopaySettings)
                .where(AUTOPAY_SETTINGS.WALLET_CID.eq(autopaySettings.getWalletCid()))
                .execute());
    }

    @Step("DB: создание записи в таблице ppc.autopay_settings")
    public void saveAutopaySettings(AutopaySettingsRecord autopaySettings) {
        run(db -> db.insertInto(AUTOPAY_SETTINGS)
                .set(autopaySettings)
                .execute());
    }

    @Step("DB: создание записи в таблице ppc.autopay_settings")
    public AutopaySettingsRecord saveDefaultCardAutopaySettings(Long walletCid, Long uid, String paymentMethod
            , BigDecimal remainingSum, BigDecimal paymentSum, int triesNum) {
        AutopaySettingsRecord autopaySettings = new AutopaySettingsRecord()
                .setPaymethodId(paymentMethod)
                .setPaymethodType(AutopaySettingsPaymethodType.card)
                .setPayerUid(uid)
                .setRemainingSum(remainingSum)
                .setPaymentSum(paymentSum)
                .setWalletCid(walletCid)
                .setTriesNum(triesNum);
        saveAutopaySettings(autopaySettings);
        return getAutopaySettings(walletCid);
    }

    @Step("DB: удаление записи из таблицы ppc.autopay_settings")
    public void deleteAutopaySettings(AutopaySettingsRecord autopaySettings) {
        run(db -> db.deleteFrom(AUTOPAY_SETTINGS)
                .where(AUTOPAY_SETTINGS.WALLET_CID.eq(autopaySettings.getWalletCid()))
                .execute());
    }

    @Step("DB: удаление записи из таблицы ppc.autopay_settings для wallet_cid = {0}")
    public void deleteAutopaySettings(Long walletCid) {
        run(db -> db.deleteFrom(AUTOPAY_SETTINGS)
                .where(AUTOPAY_SETTINGS.WALLET_CID.eq(walletCid))
                .execute());
    }

}
