package ru.yandex.autotests.direct.db.steps;


import java.sql.Timestamp;

import ru.yandex.autotests.direct.db.models.jooq.ppcdict.enums.BadDomainsTitlesStatus;
import ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.records.BadDomainsTitlesRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcDictSteps;

import static ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.BadDomainsTitles.BAD_DOMAINS_TITLES;

public class BadDomainsTitlesSteps extends BasePpcDictSteps {

    public void addDisablingDomain(String domain) {
        exec(db ->
                db.insertInto(BAD_DOMAINS_TITLES)
                        .set(new BadDomainsTitlesRecord()
                                .setDomain(domain)
                                .setStatus(BadDomainsTitlesStatus.for_disabling)
                                .setCreateTime(Timestamp.valueOf("2014-10-29 18:00:00.0")))
                        .execute());
    }

    public void addEnablingDomain(String domain) {
        exec(db ->
                db.insertInto(BAD_DOMAINS_TITLES)
                        .set(new BadDomainsTitlesRecord()
                                .setDomain(domain)
                                .setStatus(BadDomainsTitlesStatus.for_enabling)
                                .setCreateTime(Timestamp.valueOf("2014-10-29 18:00:00.0")))
                        .execute());
    }

    public void addProcessedDomain(String domain) {
        exec(db ->
                db.insertInto(BAD_DOMAINS_TITLES)
                        .set(new BadDomainsTitlesRecord()
                                .setDomain(domain)
                                .setStatus(BadDomainsTitlesStatus.processed)
                                .setCreateTime(Timestamp.valueOf("2014-10-29 18:00:00.0")))
                        .execute());
    }
}
