package ru.yandex.autotests.direct.db.steps;

import java.math.BigInteger;
import java.util.List;

import org.jooq.impl.DSL;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannerAdditionalHrefsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.TurbolandingsRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.CONTENT_PROMOTION;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.TURBOLANDINGS;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.BannerAdditionalHrefs.BANNER_ADDITIONAL_HREFS;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.BannerTurbolandings.BANNER_TURBOLANDINGS;

public class BannerAdditionalHrefSteps extends BasePpcSteps {
    @Step("DB: добавление записи в ppc.banner_additional_hrefs для bid = {0}, index = {1}, href = {2}")
    public void addBannerAdditionalHref(long bid, int index, String href) {
        long href_id = super.autoIncSteps().getNewBannerAdditionalHrefsId();
        exec(db -> db.insertInto(BANNER_ADDITIONAL_HREFS)
                .set(new BannerAdditionalHrefsRecord().setHrefId(href_id).setBid(bid).setIndex(index).setHref(href))
                .execute()
        );
    }
    @Step("Получить привязанные к баннеру допольнительные ссылки")
    public List<BannerAdditionalHrefsRecord> getBannerAdditionalHrefsData(long bannerId)
    {
        return exec(db -> db.selectFrom(BANNER_ADDITIONAL_HREFS)
                .where(BANNER_ADDITIONAL_HREFS.BID.eq(bannerId))
                .fetch());
    }
}
