package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerDisplayHrefsStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannerDisplayHrefsRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import java.util.Arrays;
import java.util.List;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.BannerDisplayHrefs.BANNER_DISPLAY_HREFS;


/**
 * Created by pashkus on 12.04.16.
 */
public class BannerDisplayHrefsSteps extends BasePpcSteps {

    public List<BannerDisplayHrefsRecord> getBannerDisplayHrefsRecords(Long ... bids) {
        return exec("Получаем записи banners_display_hrefs для bids: " + Arrays.toString(bids),
                db -> db.selectFrom(BANNER_DISPLAY_HREFS)
                        .where(BANNER_DISPLAY_HREFS.BID.in(bids))
                        .fetch());
    }

    public BannerDisplayHrefsRecord getBannerDisplayHrefs(Long bid) {
        return exec("Получаем запись banners_display_hrefs для bid=" + bid.toString(),
                db -> db.selectFrom(BANNER_DISPLAY_HREFS)
                        .where(BANNER_DISPLAY_HREFS.BID.eq(bid))
                        .fetchOptional()
                        .orElse(null));
    }

    @Step("DB: изменение записи в таблице ppc.banner_display_hrefs")
    public void updateRecord(BannerDisplayHrefsRecord bannerDisplayHrefs) {
        run(db -> db.update(BANNER_DISPLAY_HREFS)
                .set(bannerDisplayHrefs)
                .where(BANNER_DISPLAY_HREFS.BID.eq(bannerDisplayHrefs.getBid()))
                .execute());
    }

    @Step("DB: ppc.banner_display_hrefs - обновляем запись с bid={0}: displayHref={1}, statusModerate={2}")
    public void updateRecord(Long bid, String displayHref, BannerDisplayHrefsStatusmoderate statusModerate ) {
        BannerDisplayHrefsRecord displayHrefsRecord = new BannerDisplayHrefsRecord();
        displayHrefsRecord.setBid(bid);
        displayHrefsRecord.setDisplayHref(displayHref);
        displayHrefsRecord.setStatusmoderate(statusModerate);
        updateRecord(displayHrefsRecord);

    }

    @Step("DB: ppc.banner_display_hrefs - изменяем статус модерации statusModerate={1}")
    public void updateStatusModeration(Long bid, BannerDisplayHrefsStatusmoderate statusModerate) {
        BannerDisplayHrefsRecord displayHrefsRecord = new BannerDisplayHrefsRecord();
        displayHrefsRecord.setBid(bid);
        displayHrefsRecord.setStatusmoderate(statusModerate);
        updateRecord(displayHrefsRecord);
    }

    @Step("DB: создание записи в таблице ppc.banner_display_hrefs")
    public BannerDisplayHrefsRecord saveBannerDisplayHrefs(BannerDisplayHrefsRecord bannerDisplayHrefsRecord) {
        return exec(db -> db.insertInto(BANNER_DISPLAY_HREFS)
                .set(bannerDisplayHrefsRecord)
                .returning()
                .fetchOne());
    }

    @Step("DB: создание записи в таблице ppc.banner_display_hrefs")
    public BannerDisplayHrefsRecord saveBannerDisplayHrefs(long bid, String displayHref, BannerDisplayHrefsStatusmoderate statusModerate) {
        BannerDisplayHrefsRecord bannerDisplayHrefs = new BannerDisplayHrefsRecord()
                .setBid(bid)
                .setDisplayHref(displayHref)
                .setStatusmoderate(statusModerate);
        return saveBannerDisplayHrefs(bannerDisplayHrefs);
    }
}
