package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannerImagesPoolRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import java.util.List;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.BannerImagesPool.BANNER_IMAGES_POOL;

/**
 * Набор степов для работы с таблицей ppc.banner_images_pool
 */
public class BannerImagesPoolSteps extends BasePpcSteps {

    /**
     * Метод возвращает одно изображение, запись из таблицы ppc.banner_images_pool по image_hash
     *
     * @param imageHash хеш картинки
     * @return BannerImagesPoolRecord
     */
    @Step("DB: Получение записи из таблицы ppc.banner_images_pool")
    public BannerImagesPoolRecord getBannerImagesPool(Long clientId, String imageHash) {
        return exec("DB: получение изображения, записи из таблицы ppc.banner_images_pool по image_hash " + imageHash,
                db -> db.selectFrom(BANNER_IMAGES_POOL)
                        .where(BANNER_IMAGES_POOL.IMAGE_HASH.eq(imageHash),
                                BANNER_IMAGES_POOL.CLIENTID.eq(clientId))
                        .fetchOne());
    }

    /**
     * Метод возвращает несколько изображений, записи из таблицы ppc.banner_images_pool по image_hash
     *
     * @param imageHashes хеш картинки
     * @return BannerImagesPoolRecord
     */
    @Step("DB: Получение записей из таблицы ppc.banner_images_pool")
    public List<BannerImagesPoolRecord> getBannerImagesPools(Long clientId, String... imageHashes) {
        return exec("DB: получение изображений, записей из таблицы ppc.banner_images_pool по image_hash " + imageHashes,
                db -> db.selectFrom(BANNER_IMAGES_POOL)
                        .where(BANNER_IMAGES_POOL.IMAGE_HASH.in(imageHashes),
                                BANNER_IMAGES_POOL.CLIENTID.eq(clientId)
                        )
                        .fetch());
    }

    /**
     * Метод обновляет запись в таблице ppc.banner_images_pool
     *
     * @param bannerImage объект с настройками клиента
     * @return
     */
    @Step("DB: Oбновление записи в таблице ppc.banner_images_pool")
    public void updateBannerImagesPool(Long clientId, BannerImagesPoolRecord bannerImage) {
        run(db -> db.update(BANNER_IMAGES_POOL)
                .set(bannerImage)
                .where(BANNER_IMAGES_POOL.IMAGE_HASH.eq(bannerImage.getImageHash()),
                        BANNER_IMAGES_POOL.CLIENTID.eq(clientId)
                )
                .execute()
        );
    }

    /**
     * Метод удаляет все записи в таблице ppc.banner_images_pool для пользователя
     */
    @Step("DB: Удаление записей в таблице ppc.banner_images_pool для client_id = {0}")
    public void deleteBannerImagesPool(Long clientId) {
        run(db -> db.delete(BANNER_IMAGES_POOL)
                .where(BANNER_IMAGES_POOL.CLIENTID.eq(clientId))
                .execute()
        );
    }
}
