package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerMeasurersMeasurerSystem;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannerMeasurersRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersTnsRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.BannerMeasurers.BANNER_MEASURERS;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.BannersTns.BANNERS_TNS;

public class BannerMeasurerSteps extends BasePpcSteps {
    @Step("DB: добавление записи в ppc.banner_measurers для bid = {0}: measurer_system = {1}, params = {2}")
    public void addBannerMeasurer(long bid, BannerMeasurersMeasurerSystem system, String measurerJson) {
        exec(db -> db.insertInto(BANNER_MEASURERS)
                .set(new BannerMeasurersRecord().setBid(bid).setMeasurerSystem(system).setParams(measurerJson))
                .execute()
        );
    }

    @Step("DB: добавление записи в ppc.banners_tns для bid = {0}: tns_id = {1}")
    public void addTnsId(long bid, String tnsId) {
        exec(db -> db.insertInto(BANNERS_TNS)
                .set(new BannersTnsRecord().setBid(bid).setTnsId(tnsId))
                .execute()
        );
    }
}
