package ru.yandex.autotests.direct.db.steps;

import java.math.BigDecimal;

import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerPricesCurrency;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerPricesPrefix;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannerPricesRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.BANNER_PRICES;

public class BannerPricesSteps extends BasePpcSteps {
    @Step("DB: получение записи в таблице ppc.banner_prices по bid: {0}")
    public BannerPricesRecord getBannerPrices(Long bid) {
        return exec(db -> db.selectFrom(BANNER_PRICES)
                .where(BANNER_PRICES.BID.eq(bid))
                .fetchOne()
        );
    }

    @Step("DB: добавление записи в таблицу ppc.banner_prices для bid: {0}")
    public void addBannerPrice(Long bid, BannerPricesRecord record) {
        exec(db -> db.insertInto(BANNER_PRICES)
                .set(record)
                .execute());
    }

    @Step("DB: добавление записи в таблицу ppc.banner_prices для bid: {0}")
    public void addDefaultBannerPrice(Long bid) {
        exec(db -> db.insertInto(BANNER_PRICES)
                .set(BANNER_PRICES.BID, bid)
                .set(BANNER_PRICES.CURRENCY, BannerPricesCurrency.RUB)
                .set(BANNER_PRICES.PREFIX, BannerPricesPrefix.from)
                .set(BANNER_PRICES.PRICE, BigDecimal.ONE)
                .set(BANNER_PRICES.PRICE_OLD, BigDecimal.TEN)
                .execute());
    }
}
