package ru.yandex.autotests.direct.db.steps;

import com.google.gson.Gson;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannerResourcesRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import java.util.Arrays;
import java.util.List;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.BannerResources.BANNER_RESOURCES;

/**
 * Created by n-boy on 16.12.16.
 * Набор степов для работы с таблицей ppc.banner_resources
 */
public class BannerResourcesSteps extends BasePpcSteps {

    @Step("DB: создание записи в таблице ppc.banner_resources")
    public void createBannerResource(BannerResourcesRecord bannerResource) {
        exec(db -> db.insertInto(BANNER_RESOURCES)
                        .set(bannerResource)
                        .returning()
                        .fetchOne());
    }

    @Step("DB: создание записи в таблице ppc.banner_resources для bid {0} по списку id медиа-ресурсов")
    public BannerResourcesRecord createBannerResource(Long bid, List<Long> ids) {
        Long resourceId = autoIncSteps().getNewResourceId();
        BannerResourcesRecord newRecord = new BannerResourcesRecord()
                .setResourceId(resourceId)
                .setBid(bid)
                .setUsedResources(new Gson().toJson(ids));
        createBannerResource(newRecord);
        return newRecord;
    }

    @Step("DB: создание записи в таблице ppc.banner_resources для bid {0} по одному id медиа-ресурса")
    public BannerResourcesRecord createBannerResource(Long bid, Long id) {
        return createBannerResource(bid, Arrays.asList(id));
    }

    @Step("DB: обновление записи в таблице ppc.banner_resources")
    public void updateBannerResource(BannerResourcesRecord bannerResource) {
        exec(db -> db.update(BANNER_RESOURCES)
                        .set(bannerResource)
                        .where(BANNER_RESOURCES.RESOURCE_ID.eq(bannerResource.getResourceId()))
                        .execute());
    }

    @Step("DB: удаление записи в таблице ppc.banner_resources для bid: {0}")
    public void deleteBannerResourceByBid(Long bid) {
        exec(db -> db.deleteFrom(BANNER_RESOURCES)
                        .where(BANNER_RESOURCES.BID.eq(bid)));
    }

    @Step("DB: получение записи из таблицы ppc.banner_resources для bid: {0}")
    public BannerResourcesRecord getBannerResourceByBid(Long bid) {
        return exec(db -> db.selectFrom(BANNER_RESOURCES)
                        .where(BANNER_RESOURCES.BID.eq(bid))
                        .fetchOptional()
                        .orElse(null));
    }

}
