package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannerTurboGalleriesRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.BannerTurboGalleries.BANNER_TURBO_GALLERIES;

public class BannerTurboGalleriesSteps extends BasePpcSteps {

    @Step("DB: ppc.banner_turbo_galleries - добавляем баннеру {0} ссылку на турбо-галерею {1}")
    public BannerTurboGalleriesRecord setBannerTurboGalleryHref(long bid, String turboGalleryHref) {
        BannerTurboGalleriesRecord record =
                new BannerTurboGalleriesRecord()
                        .setBid(bid)
                        .setTurboGalleryHref(turboGalleryHref);
        return exec(db -> db.insertInto(BANNER_TURBO_GALLERIES)
                .set(record)
                .returning()
                .fetchOne());
    }

    @Step("DB: ppc.banner_turbo_galleries - удалить у баннера {0} ссылку на турбо-галерею")
    public void deleteBannerTurboGalleryHref(long bid) {
        exec(db -> db.deleteFrom(BANNER_TURBO_GALLERIES)
                .where(BANNER_TURBO_GALLERIES.BID.eq(bid))
                .execute());
    }
}
