package ru.yandex.autotests.direct.db.steps;

import java.util.List;

import org.jooq.impl.DSL;

import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerTurbolandingsStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.TurbolandingsStatuspostmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannerTurbolandingsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.TurbolandingsRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.BANNER_TURBOLANDING_PARAMS;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.TURBOLANDINGS;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.BannerTurbolandings.BANNER_TURBOLANDINGS;

public class BannerTurbolandingsSteps extends BasePpcSteps {
    @Step("Привязать турболендинг к баннеру добавлением записи в ppc.banner_turbolandings")
    public void linkTurbolandingToBanner(long bannerId, long campaignId, long turbolandingId,
            boolean isDisabled, BannerTurbolandingsStatusmoderate statusmoderate)
    {
        exec(db -> db.insertInto(BANNER_TURBOLANDINGS)
                .set(BANNER_TURBOLANDINGS.BID, bannerId)
                .set(BANNER_TURBOLANDINGS.CID, campaignId)
                .set(BANNER_TURBOLANDINGS.TL_ID, turbolandingId)
                .set(BANNER_TURBOLANDINGS.IS_DISABLED, isDisabled ? 1 : 0)
                .set(BANNER_TURBOLANDINGS.STATUSMODERATE, statusmoderate)
                .execute());
    }

    @Step("Получить привязанные к баннеру турболендинги")
    public List<BannerTurbolandingsRecord> getBannerTurbolandings(long bannerId)
    {
        return exec(db -> db.selectFrom(BANNER_TURBOLANDINGS)
                .where(BANNER_TURBOLANDINGS.BID.eq(bannerId))
                .fetch());
    }

    @Step("Добавить параметры к ссылке турболендинга баннера")
    public void addParamsToBannerTurbolanding(long bannerId, String params) {
        exec(db -> db.insertInto(BANNER_TURBOLANDING_PARAMS)
                .set(BANNER_TURBOLANDING_PARAMS.BID, bannerId)
                .set(BANNER_TURBOLANDING_PARAMS.HREF_PARAMS, params)
                .execute());
    }

    @Step("Получить параметры турболендинга баннера")
    public String getBannerTurbolandingParams(long bannerId) {
        return exec(db -> db.select(BANNER_TURBOLANDING_PARAMS.HREF_PARAMS)
                .from(BANNER_TURBOLANDING_PARAMS)
                .where(BANNER_TURBOLANDING_PARAMS.BID.eq(bannerId))
                .fetchOne(BANNER_TURBOLANDING_PARAMS.HREF_PARAMS));
    }

    @Step("Получить данные привязанного к баннеру турболендинга")
    public TurbolandingsRecord getBannerTurbolandingData(long bannerId)
    {
        return exec(db -> db.selectFrom(TURBOLANDINGS)
                .where(TURBOLANDINGS.TL_ID.in(
                        DSL.select(BANNER_TURBOLANDINGS.TL_ID)
                                .from(BANNER_TURBOLANDINGS)
                                .where(BANNER_TURBOLANDINGS.BID.eq(bannerId)))
                )
                .fetchOne());
    }

    @Step("Сделать запись в ppc.banner_turbolandings промодерированной")
    public void moderateBannerturbolanding(long bid) {
        exec(db -> db.update(BANNER_TURBOLANDINGS)
                .set(BANNER_TURBOLANDINGS.STATUSMODERATE, BannerTurbolandingsStatusmoderate.Yes)
                .set(BANNER_TURBOLANDINGS.IS_DISABLED, 0)
                .where(BANNER_TURBOLANDINGS.BID.eq(bid))
                .execute());
    }

    @Step("Установить статус модерации в ppc.banner_turbolandings")
    public void setBannerTurbolandingStatusModerate(long bid, BannerTurbolandingsStatusmoderate statusModerate) {
        exec(db -> db.update(BANNER_TURBOLANDINGS)
                .set(BANNER_TURBOLANDINGS.STATUSMODERATE, statusModerate)
                .set(BANNER_TURBOLANDINGS.IS_DISABLED, 0)
                .where(BANNER_TURBOLANDINGS.BID.eq(bid))
                .execute());
    }
}
