package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersContentPromotionRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.BANNERS_CONTENT_PROMOTION;

public class BannersContentPromotionSteps extends BasePpcSteps {

    @Step("DB: получение записи в таблице ppc.banners_content_promotion по bid: {0}")
    public BannersContentPromotionRecord getBannersContentPromotion(Long bid) {
        return exec(db -> db.selectFrom(BANNERS_CONTENT_PROMOTION)
                .where(BANNERS_CONTENT_PROMOTION.BID.eq(bid))
                .fetchOne()
        );
    }
}
