package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersContentPromotionVideoRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.BANNERS_CONTENT_PROMOTION_VIDEO;

public class BannersContentPromotionVideoSteps extends BasePpcSteps {

    @Step("DB: получение записи в таблице ppc.banners_content_promotion_video по bid: {0}")
    public BannersContentPromotionVideoRecord getBannersContentPromotionVideo(Long bid) {
        return exec(db -> db.selectFrom(BANNERS_CONTENT_PROMOTION_VIDEO)
                .where(BANNERS_CONTENT_PROMOTION_VIDEO.BID.eq(bid))
                .fetchOne()
        );
    }
}
