package ru.yandex.autotests.direct.db.steps;

import java.util.List;

import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersPerformanceStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PerfCreativesCreativeType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersPerformanceRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.BannersPerformance.BANNERS_PERFORMANCE;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.PerfCreatives.PERF_CREATIVES;

/*
* todo javadoc
*/
public class BannersPerformanceSteps extends BasePpcSteps {

    private static final String BID = "bid";

    @Step("DB: получение записи из таблицы ppc.banners_performance (cid = {0}, pid = {1}, bid = {2})")
    public BannersPerformanceRecord getBannersPerformance(Long cid, Long pid, Long bid) {
        return exec(db -> db.selectFrom(BANNERS_PERFORMANCE)
                .where(BANNERS_PERFORMANCE.BID.eq(bid)
                        .and(BANNERS_PERFORMANCE.PID.eq(pid))
                        .and(BANNERS_PERFORMANCE.CID.eq(cid)))
                .fetchOne());
    }

    @Step("DB: получение записи из таблицы ppc.banners_performance (bid = {0}, creativeId = {1})")
    public BannersPerformanceRecord getBannersPerformance(Long bid, Long creativeId) {
        return exec(db -> db.selectFrom(BANNERS_PERFORMANCE)
                .where(BANNERS_PERFORMANCE.BID.eq(bid)
                        .and(BANNERS_PERFORMANCE.CREATIVE_ID.eq(creativeId)))
                .fetchOne());
    }

    @Step("DB: получение записей из таблицы ppc.banners_performance (bid = {0})")
    public List<BannersPerformanceRecord> findBannersPerformance(long bid) {
        return exec(db -> db.selectFrom(BANNERS_PERFORMANCE)
                .where(BANNERS_PERFORMANCE.BID.eq(bid))
                .fetch());
    }

    @Step("DB: получение записей из таблицы ppc.banners_performance (bid = {0}, type = {1})")
    public List<Long> findBannersPerformanceIds(long bid, PerfCreativesCreativeType creativeType) {
        return exec(db -> db.select(BANNERS_PERFORMANCE.BANNER_CREATIVE_ID)
                .from(BANNERS_PERFORMANCE)
                .join(PERF_CREATIVES).on(PERF_CREATIVES.CREATIVE_ID.eq(BANNERS_PERFORMANCE.CREATIVE_ID))
                .where(BANNERS_PERFORMANCE.BID.eq(bid)
                        .and(PERF_CREATIVES.CREATIVE_TYPE.eq(creativeType)))
                .fetch(BANNERS_PERFORMANCE.BANNER_CREATIVE_ID));
    }

    @Step("DB: удаление записей из таблицы ppc.banners_performance (creative_id = {0})")
    public void deleteBannersPerformanceRecord(long creativeId) {
        run(db -> db.deleteFrom(BANNERS_PERFORMANCE)
                .where(BANNERS_PERFORMANCE.CREATIVE_ID.eq(creativeId))
                .execute());
    }

    @Step("DB: удаление записей из таблицы ppc.banners_performance (cid = {0})")
    public void deleteBannersPerformanceRecordsByCid(Long cid) {
        run(db -> db.deleteFrom(BANNERS_PERFORMANCE)
                .where(BANNERS_PERFORMANCE.CID.eq(cid))
                .execute());
    }

    @Step("DB: удаление записей из таблицы ppc.banners_performance")
    public void deleteBannersPerformanceRecords(List<Long> creativeIds) {
        run(db -> db.deleteFrom(BANNERS_PERFORMANCE)
                .where(BANNERS_PERFORMANCE.CREATIVE_ID.in(creativeIds))
                .execute());
    }

    @Step("DB: получение списка creative_id из таблицы ppc.banners_performance (bid = {0})")
    public List<Long> findCreativeIds(long bid) {
        return exec(db -> db.selectFrom(BANNERS_PERFORMANCE)
                .where(BANNERS_PERFORMANCE.BID.eq(bid))
                .fetch(BANNERS_PERFORMANCE.CREATIVE_ID));
    }

    @Step("DB: изменение записи в таблице ppc.banners_performance")
    public void updateBannersPerformance(BannersPerformanceRecord bannersPerformance) {
        run(db -> db.update(BANNERS_PERFORMANCE)
                .set(bannersPerformance)
                .where(BANNERS_PERFORMANCE.BID.eq(bannersPerformance.getBid()))
                .and(BANNERS_PERFORMANCE.CREATIVE_ID.eq(bannersPerformance.getCreativeId()))
                .execute());
    }

    @Step("DB: изменение записи в таблице ppc.banners_performance")
    public void updateBannersPerformanceById(BannersPerformanceRecord bannersPerformance) {
        run(db -> db.update(BANNERS_PERFORMANCE)
                .set(bannersPerformance)
                .where(BANNERS_PERFORMANCE.BANNER_CREATIVE_ID.eq(bannersPerformance.getBannerCreativeId()))
                .execute());
    }


    @Step("DB: создание записи в таблице ppc.banners_performance")
    public BannersPerformanceRecord saveBannersPerformance(BannersPerformanceRecord bannersPerformance) {
        return exec(db -> db.insertInto(BANNERS_PERFORMANCE)
                .set(bannersPerformance)
                .returning()
                .fetchOne());
    }

    @Step("DB: создание записи в таблице ppc.banners_performance (cid = {0}, pid = {1}, bid = {2}, creativeId = {3})")
    public BannersPerformanceRecord saveNewBannersPerformance(long cid, long pid, long bid, Long creativeId) {
        BannersPerformanceRecord bannersPerformance = new BannersPerformanceRecord()
                .setBid(bid)
                .setPid(pid)
                .setCid(cid)
                .setCreativeId(creativeId)
                .setBannerCreativeId(autoIncSteps().getNewBannerCreativeId());
        return saveBannersPerformance(bannersPerformance);
    }

    @Step("DB: установка statusModerate в таблице ppc.banners_performance (cid = {0}, pid = {1}, bid = {2}," +
            " creativeId = {3})")
    public void setCreativeStatusModerate(long cid, long pid, long bid,
            BannersPerformanceStatusmoderate statusModerate)
    {
        exec(db -> db.update(BANNERS_PERFORMANCE)
                .set(BANNERS_PERFORMANCE.STATUSMODERATE, statusModerate)
                .where(BANNERS_PERFORMANCE.BID.eq(bid)
                        .and(BANNERS_PERFORMANCE.PID.eq(pid))
                        .and(BANNERS_PERFORMANCE.CID.eq(cid)))
                .execute());
    }

    @Step("DB: выставление banners_performance.extracted_text = {1} для баннера {0}")
    public void setCreativeExtractedText(long bid, String extractedText) {
        exec(db -> db.update(BANNERS_PERFORMANCE)
                .set(BANNERS_PERFORMANCE.EXTRACTED_TEXT, extractedText)
                .where(BANNERS_PERFORMANCE.BID.eq(bid))
                .execute()
        );
    }
}
