package ru.yandex.autotests.direct.db.steps;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import java.util.Set;

import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersBannerType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersMinusGeoType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersPhoneflag;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatusactive;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatusarch;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatuspostmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatusshow;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatussitelinksmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.ModerateBannerPagesStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.ModerateBannerPagesStatusmoderateoperator;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersMinusGeoRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersMobileContentRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.BANNERS;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.BANNERS_MINUS_GEO;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.BANNERS_MOBILE_CONTENT;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.CATALOGIA_BANNERS_RUBRICS;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.DELETED_BANNERS;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.MODERATE_BANNER_PAGES;

/**
 * Created by buhter on 27/06/16.
 */
public class BannersSteps extends BasePpcSteps {
    @Step("DB: получение записи в таблице ppc.banners по bid: {0}")
    public BannersRecord getBanner(Long bid) {
        return exec(db -> db.selectFrom(BANNERS)
                .where(BANNERS.BID.eq(bid))
                .fetchOne()
        );
    }

    @Step("DB: получение записи в таблице ppc.banners по pid: {0}")
    public List<BannersRecord> getBannerByPid(Long pid) {
        return exec(db -> db.selectFrom(BANNERS)
                .where(BANNERS.PID.eq(pid))
                .fetch()
        );
    }

    @Step("DB: получение записи в таблице ppc.banners_mobile_content по bid: {0}")
    public BannersMobileContentRecord getBannersMobileContent(Long bid) {
        return exec(db -> db.selectFrom(BANNERS_MOBILE_CONTENT)
                .where(BANNERS_MOBILE_CONTENT.BID.eq(bid))
                .fetchOne()
        );
    }

    @Step("DB: получение записи в таблице ppc.banners по cid: {0}")
    public List<BannersRecord> getBannersByCid(Long cid) {
        return exec(db -> db.selectFrom(BANNERS)
                .where(BANNERS.CID.eq(cid))
                .fetch()
        );
    }

    @Step("DB: Oбновление записи в таблице ppc.banners")
    public void updateBanners(BannersRecord banners) {
        run(db -> db.update(BANNERS)
                .set(banners)
                .where(BANNERS.BID.eq(banners.getBid()))
                .execute()
        );
    }

    @Step("DB: установка domainId и domain в таблице ppc.banners для bid:{0}, domainId:{1}, domain:{2}")
    public void setBannersDomainId(Long bid, Long domainId, String domain) {
        run(db -> db.update(BANNERS)
                .set(BANNERS.DOMAIN, domain)
                .set(BANNERS.DOMAIN_ID, domainId)
                .where(BANNERS.BID.eq(bid))
                .execute()
        );
    }

    @Step("DB: установка domain в таблице ppc.banners для bid:{0}, domain:{2}")
    public void setBannersDomain(Long bid, String domain) {
        run(db -> db.update(BANNERS)
                .set(BANNERS.DOMAIN, domain)
                .where(BANNERS.BID.eq(bid))
                .execute()
        );
    }

    @Step("DB: установка href в таблице ppc.banners для bid:{0}, href:{1}")
    public void setBannersHref(Long bid, String href) {
        run(db -> db.update(BANNERS)
                .set(BANNERS.HREF, href)
                .where(BANNERS.BID.eq(bid))
                .execute()
        );
    }

    @Step("DB: добавление записи в таблицу ppc.catalogia_banners_rubrics для bid={0} c категориями: \"{1}\"")
    public void addCatalogiaBannerRubricsToBanner(Long bid, String categories) {
        run(db -> db.insertInto(CATALOGIA_BANNERS_RUBRICS)
                .set(CATALOGIA_BANNERS_RUBRICS.BID, bid)
                .set(CATALOGIA_BANNERS_RUBRICS.CATEGORIES_BS, categories)
                .execute());
    }

    @Step("DB: установка statusModerate в таблице ppc.banners для bid:{0}, statusModerate:{1}")
    public void setBannerStatusModerate(Long bid, BannersStatusmoderate statusModerate) {
        exec(db -> db.update(BANNERS)
                .set(BANNERS.STATUSMODERATE, statusModerate)
                .where(BANNERS.BID.eq(bid))
                .execute());
    }

    @Step("DB: установка statusArchived в таблице ppc.banners для bid:{0}, statusArchived:{1}")
    public void setBannerStatusArchived(Long bid, BannersStatusarch statusArchived) {
        exec(db -> db.update(BANNERS)
                .set(BANNERS.STATUSARCH, statusArchived)
                .where(BANNERS.BID.eq(bid))
                .execute());
    }

    @Step("DB: обновление ppc.banners для bid:{0}, statusModerate:{1}, statusPostModerate:{2}")
    public void setBannerStatusModerate(Long bid, BannersStatusmoderate statusModerate,
                                        BannersStatuspostmoderate statusPostModerate) {
        exec(db -> db.update(BANNERS)
                .set(BANNERS.STATUSMODERATE, statusModerate)
                .set(BANNERS.STATUSPOSTMODERATE, statusPostModerate)
                .where(BANNERS.BID.eq(bid))
                .execute());
    }

    @Step("DB: установка statusBsSynced в таблице ppc.banners для bid:{0}, statusBsSynced:{1}")
    public void setBannerStatusBsSynced(Long bid, BannersStatusbssynced statusbssynced) {
        exec(db -> db.update(BANNERS)
                .set(BANNERS.STATUSBSSYNCED, statusbssynced)
                .where(BANNERS.BID.eq(bid))
                .execute());
    }

    @Step("DB: установка statusShow в таблице ppc.banners для bid:{0}, statusBsSynced:{1}")
    public void setBannerStatusShow(Long bid, BannersStatusshow statusshow) {
        exec(db -> db.update(BANNERS)
                .set(BANNERS.STATUSSHOW, statusshow)
                .where(BANNERS.BID.eq(bid))
                .execute());
    }

    @Step("DB: установка StatusSitelinksModerate в таблице ppc.banners для bid:{0}, StatusSitelinksModerate:{1}")
    public void setStatusSitelinksModerate(Long bid, BannersStatussitelinksmoderate statusSitelinksModerate) {
        exec(db -> db.update(BANNERS)
                .set(BANNERS.STATUSSITELINKSMODERATE, statusSitelinksModerate)
                .where(BANNERS.BID.eq(bid))
                .execute());
    }

    @Step("DB: установка Phoneflag в таблице ppc.banners для bid:{0}, Phoneflag:{1}")
    public void setPhoneflag(Long bid, BannersPhoneflag phoneflag) {
        exec(db -> db.update(BANNERS)
                .set(BANNERS.PHONEFLAG, phoneflag)
                .where(BANNERS.BID.eq(bid))
                .execute());
    }

    @Step("DB: выставить поля null в таблице ppc.banners для bid:{0} чтобы сделать баннер performance ")
    public void makeBannerPerformance(Long bid) {
        run(db -> db.update(BANNERS)
                .set(BANNERS.HREF, (String) null)
                .set(BANNERS.DOMAIN, (String) null)
                .set(BANNERS.REVERSE_DOMAIN, (String) null)
                .set(BANNERS.DOMAIN_ID, (Long) null)
                .where(BANNERS.BID.eq(bid))
                .execute()
        );
    }

    @Step("DB: установка statusPostModerate в таблице ppc.banners для bid:{0}, statusModerate: {1}")
    public void setBannerStatusPostModerate(Long bid, BannersStatuspostmoderate statusModerate) {
        exec(db -> db.update(BANNERS)
                .set(BANNERS.STATUSPOSTMODERATE, statusModerate)
                .where(BANNERS.BID.eq(bid))
                .execute());
    }

    @Step("DB: установка statusActive в таблице ppc.banners для bid:{0}, statusActive: {1}")
    public void setBannerStatusActive(Long bid, BannersStatusactive statusActive) {
        exec(db -> db.update(BANNERS)
                .set(BANNERS.STATUSACTIVE, statusActive)
                .where(BANNERS.BID.eq(bid))
                .execute());
    }

    @Step("DB: установка bannerType в таблице ppc.banners для bid:{0}, bannerType:{1}")
    public void setBannersBannerType(Long bid, BannersBannerType bannerType) {
        exec(db -> db.update(BANNERS)
                .set(BANNERS.BANNER_TYPE, bannerType)
                .where(BANNERS.BID.eq(bid))
                .execute());
    }

    @Step("DB: установка flags в таблице ppc.banners для bid:{0}, flags:{1}")
    public void setBannersFlags(Long bid, String flags) {
        exec(db -> db.update(BANNERS)
                .set(BANNERS.FLAGS, flags)
                .where(BANNERS.BID.eq(bid))
                .execute());
    }

    @Step("DB: установка title в таблице ppc.banners для bid:{0}, title:{1}")
    public void setBannersTitle(Long bid, String title) {
        exec(db -> db.update(BANNERS)
                .set(BANNERS.TITLE, title)
                .where(BANNERS.BID.eq(bid))
                .execute());
    }

    @Step("DB: установка body в таблице ppc.banners для bid:{0}, body:{1}")
    public void setBannersBody(Long bid, String body) {
        exec(db -> db.update(BANNERS)
                .set(BANNERS.BODY, body)
                .where(BANNERS.BID.eq(bid))
                .execute());
    }

    @Step("DB: установка yaContextCategories в таблице ppc.banners для bid:{0}, yaContextCategories:{1}")
    public void setBannersYaContextCategories(Long bid, String yaContextCategories) {
        exec(db -> db.update(BANNERS)
                .set(BANNERS.YACONTEXTCATEGORIES, yaContextCategories)
                .where(BANNERS.BID.eq(bid))
                .execute());
    }

    @Step("DB: получение записи из таблицы ppc.banners_minus_geo (bid = {0}")
    public List<BannersMinusGeoRecord> getBannersMinusGeo(Long bid) {
        return exec(db ->
                db.selectFrom(BANNERS_MINUS_GEO)
                        .where(BANNERS_MINUS_GEO.BID.eq(bid))
                        .fetch());
    }

    @Step("DB: получение записи из таблицы ppc.banners_minus_geo (bid = {0}, type = {1})")
    public BannersMinusGeoRecord getBannersMinusGeo(Long bid, BannersMinusGeoType type) {
        return exec(db ->
                db.selectFrom(BANNERS_MINUS_GEO)
                        .where(BANNERS_MINUS_GEO.BID.eq(bid).and(BANNERS_MINUS_GEO.TYPE.eq(type)))
                        .fetchOne());
    }

    @Step("DB: изменение записи в таблице ppc.banners_minus_geo")
    public void updateBannersMinusGeo(BannersMinusGeoRecord bannersMinusGeo) {
        run(db ->
                db.update(BANNERS_MINUS_GEO)
                        .set(bannersMinusGeo)
                        .where(BANNERS_MINUS_GEO.BID.eq(bannersMinusGeo.getBid()))
                        .execute());
    }

    @Step("DB: создание записи в таблице ppc.banners_minus_geo")
    public void saveBannersMinusGeo(BannersMinusGeoRecord bannersMinusGeo) {
        run(db ->
                db.insertInto(BANNERS_MINUS_GEO)
                        .set(bannersMinusGeo)
                        .execute());
    }

    @Step("DB: добавление/обновление записи в ppc.banners_minus_geo: bid={0}, minus_geo={1}")
    public void saveBannersMinusGeo(Long bid, BannersMinusGeoType type, String minusGeo) {
        exec(db -> db.insertInto(BANNERS_MINUS_GEO, BANNERS_MINUS_GEO.BID, BANNERS_MINUS_GEO.TYPE,
                BANNERS_MINUS_GEO.MINUS_GEO)
                .values(bid, type, minusGeo)
                .onDuplicateKeyUpdate()
                .set(BANNERS_MINUS_GEO.MINUS_GEO, minusGeo)
                .execute()
        );
    }

    @Step("DB: удаление записи в ppc.banners_minus_geo: bid={0}, type={1}")
    public void deleteBannersMinusGeo(Long bid, BannersMinusGeoType type) {
        exec(db -> db.deleteFrom(BANNERS_MINUS_GEO)
                .where(BANNERS_MINUS_GEO.BID.eq(bid)
                        .and(BANNERS_MINUS_GEO.TYPE.eq(type)))
                .execute()
        );
    }

    @Step("DB: установка LastChange в таблице ppc.banners для bid:{0}, LastChange:{1}")
    public void setBannersLastChange(Long bid, Timestamp lastChange) {
        exec(db -> db.update(BANNERS)
                .set(BANNERS.LASTCHANGE, lastChange)
                .where(BANNERS.BID.eq(bid))
                .execute());
    }

    @Step("DB: установка pid в таблице ppc.banners для bid:{0}, pid:{1}")
    public void setBannersPid(Long bid, Long pid) {
        exec(db -> db.update(BANNERS)
                .set(BANNERS.PID, pid)
                .where(BANNERS.BID.eq(bid))
                .execute());
    }

    @Step("DB: получение ID удаленных баннеров из таблицы ppc.deleted_banners для списка bid:{0}")
    public Set<Long> getDeletedBanners(Collection<Long> bannerIds) {
        return exec(db -> db.select(DELETED_BANNERS.BID)
                .from(DELETED_BANNERS)
                .where(DELETED_BANNERS.BID.in(bannerIds))
                .fetchSet(DELETED_BANNERS.BID));
    }

    @Step("DB: добавление записи в таблицу ppc.moderate_banner_pages для bid={0} pageId={1} cо статусом: {2}")
    public void addModerateBannerPage(Long bid, Long pageId, ModerateBannerPagesStatusmoderate statusmoderate) {
        addModerateBannerPageInner(bid, pageId, statusmoderate, ModerateBannerPagesStatusmoderateoperator.None, 0, null);
    }

    @Step("DB: добавление записи в таблицу ppc.moderate_banner_pages для bid={0} pageId={1} cо статусом: {2}")
    public void addModerateBannerPage(Long bid, Long pageId, Integer isRemoved, ModerateBannerPagesStatusmoderate statusmoderate,
                                      ModerateBannerPagesStatusmoderateoperator statusModerateOperator, String taskUrl) {
        addModerateBannerPageInner(bid, pageId, statusmoderate, statusModerateOperator, isRemoved, taskUrl);
    }

    @Step("DB: добавление записи в таблицу ppc.moderate_banner_pages для bid={0} pageId={1} cо статусом: {2} и " +
            "таксурлом {3}")
    public void addModerateBannerPageWithUrl(Long bid, Long pageId, ModerateBannerPagesStatusmoderate statusmoderate,
                                             String taskUrl) {
        addModerateBannerPageInner(bid, pageId, statusmoderate, ModerateBannerPagesStatusmoderateoperator.None, 0, taskUrl);
    }

    private void addModerateBannerPageInner(Long bid, Long pageId, ModerateBannerPagesStatusmoderate statusmoderate,
                                            ModerateBannerPagesStatusmoderateoperator statusModerateOperator, Integer isRemoved,
                                            String taskUrl) {
        run(db -> db.insertInto(MODERATE_BANNER_PAGES)
                .set(MODERATE_BANNER_PAGES.MODERATE_BANNER_PAGE_ID, super.autoIncSteps().getNewModerateBannerPageId())
                .set(MODERATE_BANNER_PAGES.BID, bid)
                .set(MODERATE_BANNER_PAGES.PAGEID, pageId)
                .set(MODERATE_BANNER_PAGES.VERSION, (short) 1)
                .set(MODERATE_BANNER_PAGES.IS_REMOVED, isRemoved)
                .set(MODERATE_BANNER_PAGES.TASK_URL, taskUrl)
                .set(MODERATE_BANNER_PAGES.STATUSMODERATE, statusmoderate)
                .set(MODERATE_BANNER_PAGES.STATUSMODERATEOPERATOR, statusModerateOperator)
                .execute());
    }

    @Step("DB: добавление записи в таблицу ppc.banners")
    public Long addBanner(BannersRecord banner, Long clientId) {
        Long bid = shardingSteps().getNextBid(clientId);
        banner.setBid(bid);

        run(db -> db.insertInto(BANNERS)
                .set(banner)
                .execute()
        );
        return bid;
    }
}

