package ru.yandex.autotests.direct.db.steps;

import java.math.BigInteger;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BidsManualPricesRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.BIDS_MANUAL_PRICES;
import static ru.yandex.autotests.irt.testutils.allure.AllureUtils.addJsonAttachment;

public class BidsManualPricesSteps extends BasePpcSteps {
    @Step("DB: получение сохранненой копии ставок из таблицы ppc.bids_manual_prices (cid = {0}, bidsId = {1})")
    public BidsManualPricesRecord getBidsManualPrices(long cid, BigInteger bidsId) {
        BidsManualPricesRecord retVal = exec(db -> db.selectFrom(BIDS_MANUAL_PRICES)
                .where(BIDS_MANUAL_PRICES.CID.eq(cid).and(BIDS_MANUAL_PRICES.ID.eq(bidsId)))
                .fetchAny());
        String logRecord = retVal == null ? "null" : JsonUtils.toStringLow(retVal.intoMap());
        getLogger().info("Получена запись из таблицы ppc.bids_manual_prices: " + logRecord);
        addJsonAttachment("Получена запись", logRecord);
        return retVal;
    }
}
