package ru.yandex.autotests.direct.db.steps;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.List;

import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BidsPerformanceNowOptimizingBy;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BidsPerformanceStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BidsPerformanceTargetFunnel;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BidsPerformanceRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.BidsPerformance.BIDS_PERFORMANCE;


/**
 * Created by pashkus on 02.09.16.
 */

public class BidsPerformanceSteps extends BasePpcSteps {

    @Step("DB: получение записи из таблицы ppc.bids_performance (perf_filter_id = {0})")
    public BidsPerformanceRecord getBidsPerformance(long perfFilterId) {
        return exec(db -> db.selectFrom(BIDS_PERFORMANCE)
                .where(BIDS_PERFORMANCE.PERF_FILTER_ID.eq(perfFilterId))
                .fetchOne());
    }

    @Step("DB: изменение записи в таблице ppc.bids_performance")
    public void updateBidsPerformance(BidsPerformanceRecord bidsPerformanceRecord) {
        run(db -> db.update(BIDS_PERFORMANCE)
                .set(bidsPerformanceRecord)
                .where(BIDS_PERFORMANCE.PERF_FILTER_ID.eq(bidsPerformanceRecord.getPerfFilterId()))
                .execute());
    }

    @Step("DB: создание записи в таблице ppc.bids_performance")
    public BidsPerformanceRecord saveBidsPerformance(BidsPerformanceRecord bidsPerformanceRecord) {
        return exec(db -> db.insertInto(BIDS_PERFORMANCE)
                .set(bidsPerformanceRecord)
                .returning()
                .fetchOne());
    }


    @Step("DB: создание записи в таблице ppc.bids_performance c name = {2}")
    public Long saveDefaultBidsPerformanceWithName(Long pid, BidsPerformanceNowOptimizingBy nowOptimizingBy, String name) {
        Long id = autoIncSteps().getNewPerfFilterId();
        BidsPerformanceRecord bidsPerformanceRecord = new BidsPerformanceRecord()
                .setPerfFilterId(id)
                .setPid(pid)
                .setName(name)
                .setPriceCpc(BigDecimal.ZERO)
                .setPriceCpa(BigDecimal.ZERO)
                .setTargetFunnel(BidsPerformanceTargetFunnel.product_page_visit)
                .setConditionJson("{\"not_empty_json\": 1}")
                .setNowOptimizingBy(nowOptimizingBy)
                .setLastchange(Timestamp.valueOf(LocalDateTime.now()))
                .setStatusbssynced(BidsPerformanceStatusbssynced.Yes)
                .setIsDeleted(0);
        saveBidsPerformance(bidsPerformanceRecord);
        return id;
    }

    public Long saveDefaultBidsPerformance(Long pid, BidsPerformanceNowOptimizingBy nowOptimizingBy) {
        return saveDefaultBidsPerformanceWithName(pid, nowOptimizingBy, "testName");
    }

    @Step("DB: получение записей из таблицы ppc.bids_performance c pid = {0}")
    public List<BidsPerformanceRecord> getBidsPerformanceByPid(Long pid) {
        return exec(db -> db.selectFrom(BIDS_PERFORMANCE)
                .where(BIDS_PERFORMANCE.PID.eq(pid))
                .fetch());
    }
}
