package ru.yandex.autotests.direct.db.steps;

import java.util.List;

import javax.util.streamex.StreamEx;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BidsRetargetingRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.BIDS_RETARGETING;
import static ru.yandex.autotests.irt.testutils.allure.AllureUtils.addJsonAttachment;

public class BidsRetargetingSteps extends BasePpcSteps {

    @Step("DB: получение ретаргетинга из таблицы ppc.bids_retargeting (ret_id = {0})")
    public BidsRetargetingRecord getBidsRetargeting(long retId) {
        return exec(db -> db.selectFrom(BIDS_RETARGETING)
                .where(BIDS_RETARGETING.RET_ID.eq(retId))
                .fetchOne());
    }

    @Step("DB: получение ретаргетингов из таблицы ppc.bids_retargeting (bid = {0})")
    public List<BidsRetargetingRecord> getBidsRetargetingByBid(long bid) {
        List<BidsRetargetingRecord> result = exec(db -> db.selectFrom(BIDS_RETARGETING)
                .where(BIDS_RETARGETING.BID.eq(bid))
                .fetch()
        );

        String logRecord = getLogRecord(result);
        getLogger().info("полученные записи из таблицы ppc.bids_retargeting: " + logRecord);
        addJsonAttachment("полученные записи", logRecord);

        return result;
    }

    @Step("DB: получение ретаргетингов из таблицы ppc.bids_retargeting (pid = {0})")
    public List<BidsRetargetingRecord> getBidsRetargetingByPid(long pid) {
        List<BidsRetargetingRecord> result = exec(db -> db.selectFrom(BIDS_RETARGETING)
                .where(BIDS_RETARGETING.PID.eq(pid))
                .fetch()
        );

        String logRecord = getLogRecord(result);
        getLogger().info("полученные записи из таблицы ppc.bids_retargeting: " + logRecord);
        addJsonAttachment("полученные записи", logRecord);

        return result;
    }

    @Step("DB: добавление записи в ppc.bids_retargeting")
    public Long addBidsRetargeting(BidsRetargetingRecord record) {
        Long retId = autoIncSteps().getNewRetargetingId();
        record.setRetId(retId);
        exec(db -> db.insertInto(BIDS_RETARGETING)
                .set(record)
                .execute()
        );
        return retId;
    }

    @Step("DB: удаление записи из ppc.bids_retargeting id = {0}")
    public void deleteRetargeting(Long retId) {
        run(db -> db.deleteFrom(BIDS_RETARGETING)
                .where(BIDS_RETARGETING.RET_ID.eq(retId))
                .execute()
        );
    }

    @Step("DB: изменение ретаргетинга в таблице ppc.bids_retargeting")
    public void updateBidsRetargeting(BidsRetargetingRecord bidsRetargetingRecord) {
        String logRecord = JsonUtils.toStringLow(bidsRetargetingRecord.intoMap());
        getLogger().info("Обновление: " + logRecord);
        addJsonAttachment("обновление", logRecord);
        run(db -> db.update(BIDS_RETARGETING)
                .set(bidsRetargetingRecord)
                .where(BIDS_RETARGETING.RET_ID.eq(bidsRetargetingRecord.getRetId()))
                .execute()
        );
    }

    private static String getLogRecord(List<BidsRetargetingRecord> result) {
        if (result != null) {
            return JsonUtils.toStringLow(StreamEx.of(result).map(BidsRetargetingRecord::intoMap).toList());
        } else {
            return "null";
        }
    }
}
