package ru.yandex.autotests.direct.db.steps;
//Task: TESTIRT-9409.

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

import javax.util.streamex.StreamEx;

import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BidsPerformanceNowOptimizingBy;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BidsPerformanceStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BidsPerformanceTargetFunnel;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BidsStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BidsWarn;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BidsDynamicRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BidsHrefParamsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BidsPerformanceRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BidsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BidsRetargetingRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.autotests.irt.testutils.RandomUtils;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.BIDS_RETARGETING;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.Bids.BIDS;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.BidsDynamic.BIDS_DYNAMIC;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.BidsHrefParams.BIDS_HREF_PARAMS;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.BidsPerformance.BIDS_PERFORMANCE;
import static ru.yandex.autotests.irt.testutils.allure.AllureUtils.addJsonAttachment;

public class BidsSteps extends BasePpcSteps {
    @Step("DB: получение записи в таблице ppc.bids по cid: {0}")
    public BidsRecord getBidByCid(Long cid) {
        return exec(db -> db.selectFrom(BIDS)
                .where(BIDS.CID.eq(cid))
                .fetchOne()
        );
    }

    @Step("DB: получение записи в таблице ppc.bids по cid: {0}")
    public List<BidsRecord> getBidsByCid(Long cid) {
        return exec(db -> db.selectFrom(BIDS)
                .where(BIDS.CID.eq(cid))
                .fetch()
        );
    }

    @Step("DB: получение записи в таблице ppc.bids по pid: {0}")
    public List<BidsRecord> getBidsByPid(Long pid) {
        return exec(db -> db.selectFrom(BIDS)
                .where(BIDS.PID.eq(pid))
                .fetch()
        );
    }

    @Step("DB: получение записи в таблице ppc.bids по id: {0}")
    public BidsRecord getBidById(Long id) {
        return exec(db -> db.selectFrom(BIDS)
                .where(BIDS.ID.eq(id))
                .fetchOne()
        );
    }

    @Step("DB: Oбновление записи в таблице ppc.bids")
    public void updateBids(BidsRecord bid) {
        run(db -> db.update(BIDS)
                .set(bid)
                .where(BIDS.ID.eq(bid.getId()))
                .execute()
        );
    }

    @Step("DB: Oбновление поля place в таблице ppc.bids, id: {0}, place: {1}, warn: {2}")
    public void setBidsPlace(Long id, int place, BidsWarn warn) {
        run(db -> db.update(BIDS)
                .set(BIDS.PLACE, place)
                .set(BIDS.WARN, warn)
                .where(BIDS.ID.eq(id))
                .execute()
        );
    }

    @Step("DB: Oбновление поля statusModerate в таблице ppc.bids, id: {0}, statusModerate: {1}")
    public void setBidsStatusModerate(Long id, BidsStatusmoderate bidsStatusmoderate) {
        run(db -> db.update(BIDS)
                .set(BIDS.STATUSMODERATE, bidsStatusmoderate)
                .where(BIDS.ID.eq(id))
                .execute()
        );
    }

    @Step("DB: Oбновление поля price в таблице ppc.bids, id: {0}, price: {1}")
    public void setBidsPrice(Long id, BigDecimal price) {
        run(db -> db.update(BIDS)
                .set(BIDS.PRICE, price)
                .where(BIDS.ID.eq(id))
                .execute()
        );
    }

    @Step("DB: Oбновление поля price_context в таблице ppc.bids, id: {0}, price_context: {1}")
    public void setBidsPriceContext(Long id, BigDecimal priceContext) {
        run(db -> db.update(BIDS)
                .set(BIDS.PRICE_CONTEXT, priceContext)
                .where(BIDS.ID.eq(id))
                .execute()
        );
    }

    @Step("DB: установить статус suspended (id = {0}")
    public void setSuspended(Long id) {
        run(db -> db.update(BIDS)
                .set(BIDS.IS_SUSPENDED, 1)
                .where(BIDS.ID.eq(id))
                .execute()
        );
    }

    @Step("DB: создание записи в таблице ppc.bids_performance")
    public Long saveBidsPerformance(BidsPerformanceRecord bidsPerformance) {
        Long perfFilterId = autoIncSteps().getNewPerfFilterId();
        run(db ->
                db.insertInto(BIDS_PERFORMANCE)
                        .set(bidsPerformance.setPerfFilterId(perfFilterId))
                        .returning(BIDS_PERFORMANCE.fields())
                        .fetchOne());
        return perfFilterId;
    }

    @Step("DB: создание записи в таблице ppc.bids_href_params")
    public void saveBidsHrefParams(BidsHrefParamsRecord bidsHrefParamsRecord) {
        run(db ->
                db.insertInto(BIDS_HREF_PARAMS)
                        .set(bidsHrefParamsRecord)
                        .execute());
    }

    @Step("DB: получение записи в таблице ppc.bids_href_params по cid: {0}")
    public BidsHrefParamsRecord getBidsHrefParamsByCid(Long cid) {
        return exec(db -> db.selectFrom(BIDS_HREF_PARAMS)
                .where(BIDS_HREF_PARAMS.CID.eq(cid))
                .fetchOne()
        );
    }

    @Step("DB: получение записи в таблице ppc.bids_performance по perf_filter_id: {0}")
    public BidsPerformanceRecord getBidsPerformance(Long perfFilterId) {
        return exec(db -> db.selectFrom(BIDS_PERFORMANCE)
                .where(BIDS_PERFORMANCE.PERF_FILTER_ID.eq(perfFilterId))
                .fetchOne()
        );
    }

    @Step("DB: получение записи в таблице ppc.bids_performance по pid: {0}")
    public List<BidsPerformanceRecord> getBidsPerformanceByPid(Long pid) {
        return exec(db -> db.selectFrom(BIDS_PERFORMANCE)
                .where(BIDS_PERFORMANCE.PID.eq(pid))
                .fetch()
        );
    }

    @Step("DB: Oбновление записи в таблице ppc.bids_performance")
    public void updateBidsPerformance(BidsPerformanceRecord bidsPerformance) {
        run(db -> db.update(BIDS_PERFORMANCE)
                .set(bidsPerformance)
                .where(BIDS_PERFORMANCE.PERF_FILTER_ID.eq(bidsPerformance.getPerfFilterId()))
                .execute()
        );
    }

    @Step("DB: Oбновление записи в таблице ppc.bids_performance")
    public void seveDefaultBidsPerformance(BidsPerformanceRecord bidsPerformance) {
        run(db -> db.update(BIDS_PERFORMANCE)
                .set(bidsPerformance)
                .where(BIDS_PERFORMANCE.PERF_FILTER_ID.eq(bidsPerformance.getPerfFilterId()))
                .execute()
        );
    }

    public BidsPerformanceRecord getDefaultBidsPerfomance(Long pid) {
        return new BidsPerformanceRecord()
                .setPid(pid)
                .setName(RandomUtils.getString(16))
                .setPriceCpc(BigDecimal.ZERO)
                .setPriceCpa(BigDecimal.ZERO)
                .setTargetFunnel(BidsPerformanceTargetFunnel.product_page_visit)
                .setConditionJson("{\"not_empty_json\": 1}")
                .setNowOptimizingBy(BidsPerformanceNowOptimizingBy.CPA)
                .setLastchange(Timestamp.from(Instant.now()))
                .setStatusbssynced(BidsPerformanceStatusbssynced.Yes)
                .setIsDeleted(0);
    }

    @Step("DB: получение записи в таблице ppc.bids_retargeting по pid: {0}")
    public List<BidsRetargetingRecord> getBidsRetargetingRecordByPid(Long pid) {
        return exec(db -> db.selectFrom(BIDS_RETARGETING)
                .where(BIDS_RETARGETING.PID.eq(pid))
                .fetch()
        );
    }

    @Step("DB: получение записи в таблице ppc.bids_retargeting по ret_id: {0}")
    public BidsRetargetingRecord getBidsRetargetingRecordByRetId(Long retId) {
        return exec(db -> db.selectFrom(BIDS_RETARGETING)
                .where(BIDS_RETARGETING.RET_ID.eq(retId))
                .fetchOne()
        );
    }

    @Step("DB: Oбновление записи в таблице ppc.bids_retargeting")
    public void updateBidsRetargeting(BidsRetargetingRecord record) {
        run(db -> db.update(BIDS_RETARGETING)
                .set(record)
                .where(BIDS_RETARGETING.RET_ID.eq(record.getRetId()))
                .execute()
        );
    }

    @Step("DB: установить случайное значение для PhraseID")
    public BigInteger setRandomPhraseId(Long phraseId) {
        BigInteger bsPhraseId = new BigInteger(64, ThreadLocalRandom.current());
        run(db -> db.update(BIDS)
                .set(BIDS.PHRASEID, bsPhraseId)
                .where(BIDS.ID.eq(phraseId))
                .execute()
        );
        return bsPhraseId;
    }

    @Step("DB: получение записей в таблице ppc.bids_dynamic по pid: {0}")
    public List<BidsDynamicRecord> getBidsDynamicByPid(Long pid) {
        List<BidsDynamicRecord> result = exec(db -> db.selectFrom(BIDS_DYNAMIC)
                .where(BIDS_DYNAMIC.PID.eq(pid))
                .fetch());

        String logRecord;
        if (result != null) {
            logRecord = JsonUtils.toStringLow(StreamEx.of(result).map(r -> r.intoMap()).toList());
        } else {
            logRecord = "null";
        }
        getLogger().info("полученные записи из таблицы ppc.bids_dynamic: " + logRecord);
        addJsonAttachment("полученные записи", logRecord);

        return result;
    }


    @Step("DB: Oбновление поля price в таблице ppc.bids_dynamic, id: {0}, price: {1}")
    public void setBidsDynamicPrice(Long id, BigDecimal price) {
        run(db -> db.update(BIDS_DYNAMIC)
                .set(BIDS_DYNAMIC.PRICE, price)
                .where(BIDS_DYNAMIC.DYN_COND_ID.eq(id))
                .execute()
        );
    }

    @Step("DB: Oбновление поля price_context в таблице ppc.bids_dynamic, id: {0}, price_context: {1}")
    public void setBidsDynamicPriceContext(Long id, BigDecimal priceContext) {
        run(db -> db.update(BIDS_DYNAMIC)
                .set(BIDS_DYNAMIC.PRICE_CONTEXT, priceContext)
                .where(BIDS_DYNAMIC.DYN_COND_ID.eq(id))
                .execute()
        );
    }
}
