package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsType;
import ru.yandex.autotests.direct.db.models.jooq.ppcdict.enums.ProductsType;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import javax.util.streamex.EntryStream;
import java.util.Map;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.Campaigns.CAMPAIGNS;

public class BillingAggregateSteps extends BasePpcSteps {
    @Step("DB: Получение ID биллинговых агрегатов под общим счетом {0}")
    public Map<ProductsType, Long> getBillingAggregateIds(Long walletId, Map<Long, ProductsType> productTypeByProductId) {
        Map<Long, Long> idByProductId =
                exec(db -> db.select(CAMPAIGNS.CID, CAMPAIGNS.PRODUCTID)
                        .from(CAMPAIGNS)
                        .where(CAMPAIGNS.WALLET_CID.eq(walletId)).and(CAMPAIGNS.TYPE.eq(CampaignsType.billing_aggregate))
                        .fetchMap(CAMPAIGNS.PRODUCTID, CAMPAIGNS.CID)
                );

        return EntryStream.of(idByProductId)
                .mapKeys(productTypeByProductId::get)
                .toMap();
    }
}
