package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BsDeadDomainsRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import java.sql.Timestamp;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.BsDeadDomains.BS_DEAD_DOMAINS;

/**
 * Created by pavryabov on 15.06.16.
 */
public class BsDeadDomainsSteps extends BasePpcSteps {

    @Step("DB: запись в таблицу ppc.bs_dead_domains")
    public void createBsDeadDomains(BsDeadDomainsRecord bsDeadDomainsRecord) {
        exec(db -> db.insertInto(BS_DEAD_DOMAINS)
                .set(bsDeadDomainsRecord)
                .execute());
    }

    public void createBsDeadDomains(Long domainId, Timestamp lastChange) {
        createBsDeadDomains(new BsDeadDomainsRecord(domainId, lastChange));
    }

    @Step("DB: чтение из таблицы ppc.bs_dead_domains, domain_id = {0}")
    public BsDeadDomainsRecord getBsDeadDomain(Long domainId) {
        return exec(db ->
                db.selectFrom(BS_DEAD_DOMAINS)
                        .where(BS_DEAD_DOMAINS.DOMAIN_ID.eq(domainId))
                        .fetchOne());
    }

    @Step("DB: удаление из таблицы ppc.bs_dead_domains")
    public void deleteBsDeadDomains(Long... bsDeadDomainsRecordIds) {
        exec(db -> db.deleteFrom(BS_DEAD_DOMAINS)
                .where(BS_DEAD_DOMAINS.DOMAIN_ID.in(bsDeadDomainsRecordIds))
                .execute());
    }

}
