package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BsExportQueueRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.BS_EXPORT_QUEUE;
import static ru.yandex.autotests.irt.testutils.allure.AllureUtils.addJsonAttachment;

/**
 * Created by gerdler on 28/12/2018.
 */

public class BsExportQueueSteps extends BasePpcSteps {

    @Step("DB: получение записи в таблице ppc.bs_export_queue по cid: {0}")
    public BsExportQueueRecord getBsExportQueueRecord(Long cid) {
        return exec(db -> db.selectFrom(BS_EXPORT_QUEUE)
                .where(BS_EXPORT_QUEUE.CID.eq(cid))
                .fetchOne()
        );
    }

    @Step("DB: запись в таблицу ppc.bs_export_queue")
    public void createBsExportQueue(BsExportQueueRecord bsExportQueueRecord) {
        exec(db -> db.insertInto(BS_EXPORT_QUEUE)
                .set(bsExportQueueRecord)
                .execute());
    }

    @Step("DB: удаление из таблицы ppc.bs_export_queue")
    public void deleteBsExportQueue(Long cid) {
        BsExportQueueRecord record = getBsExportQueueRecord(cid);
        if (record != null) {
            String logRecord = JsonUtils.toStringLow(record.intoMap());
            getLogger().info("удаляемая запись из таблицы ppc.bs_export_queue: " + logRecord);
            addJsonAttachment("удаляемая запись", logRecord);
        } else {
            getLogger().info("Запись в таблице ppc.bs_export_queue отсутствует для cid = " + cid);
            return;
        }
        exec(db -> db.deleteFrom(BS_EXPORT_QUEUE)
                .where(BS_EXPORT_QUEUE.CID.eq(cid))
                .execute());
    }
}

