package ru.yandex.autotests.direct.db.steps;

import java.sql.Timestamp;

import org.jooq.Record1;
import org.jooq.impl.DSL;

import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.CAMP_AGGREGATED_LASTCHANGE;

public class CampAggregatedLastChangeSteps extends BasePpcSteps {
    public boolean isRecordExists(Long campaignId) {
        return exec(db -> db.select(DSL.val(true))
                .from(CAMP_AGGREGATED_LASTCHANGE)
                .where(CAMP_AGGREGATED_LASTCHANGE.CID.eq(campaignId))
                .fetchOptional()
                .map(Record1::value1)
                .orElse(false));
    }

    @Step("DB: Oбновление записи в таблице ppc.camp_aggregated_lastchange для кампании {0}")
    public void updateLastChange(Long cid, Timestamp lastChanged) {
        run(db -> db.insertInto(CAMP_AGGREGATED_LASTCHANGE)
                .columns(CAMP_AGGREGATED_LASTCHANGE.CID, CAMP_AGGREGATED_LASTCHANGE.LAST_CHANGE)
                .values(cid, lastChanged)
                .onDuplicateKeyUpdate()
                .set(CAMP_AGGREGATED_LASTCHANGE.LAST_CHANGE, lastChanged)
                .execute());
    }

    @Step("DB: Удаляем запись в таблице ppc.camp_aggregated_lastchange для кампании {0}")
    public void removeLastChange(Long campaignId) {
        run(db -> db.deleteFrom(CAMP_AGGREGATED_LASTCHANGE)
                .where(CAMP_AGGREGATED_LASTCHANGE.CID.eq(campaignId))
                .execute());
    }
}
