package ru.yandex.autotests.direct.db.steps;

import java.util.List;

import ru.yandex.autotests.direct.db.models.jooq.ppc.Tables;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampMetrikaGoalsRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.CampMetrikaGoals.CAMP_METRIKA_GOALS;

public class CampMetrikaGoalsSteps extends BasePpcSteps {

    public void createCampMetrikaGoals(Long cid, Long goalId, Long goalsCount, Long contextGoalsCount) {
        createCampMetrikaGoals(
                new CampMetrikaGoalsRecord()
                        .setCid(cid)
                        .setGoalId(goalId)
                        .setGoalsCount(goalsCount)
                        .setContextGoalsCount(contextGoalsCount));
    }

    public void createCampMetrikaGoals(CampMetrikaGoalsRecord campMetrikaGoalsRecord) {
        run("DB: добавление записи в таблицу ppc.camp_metrika_goals",
                db -> db.insertInto(CAMP_METRIKA_GOALS)
                        .set(campMetrikaGoalsRecord)
                        .execute()
        );
    }

    @Step("DB: Удаление записи в таблице ppc.camp_metrika_goals")
    public void deleteCampMetrikaGoals(Long cid, Long goalId) {
        run(db -> db.deleteFrom(Tables.CAMP_METRIKA_GOALS)
                .where(CAMP_METRIKA_GOALS.CID.eq(cid))
                .and(CAMP_METRIKA_GOALS.GOAL_ID.eq(goalId))
                .execute()
        );
    }

    public CampMetrikaGoalsRecord getCampMetrikaGoalRecord(Long cid, Long goalId) {
        return exec("DB: получение записи из таблицы ppc.camp_metrika_goals",
                db -> db.selectFrom(CAMP_METRIKA_GOALS)
                        .where(CAMP_METRIKA_GOALS.CID.eq(cid).and(CAMP_METRIKA_GOALS.GOAL_ID.eq(goalId)))
                        .fetchOne()
        );
    }

    public List<CampMetrikaGoalsRecord> getCampMetrikaGoalRecords(Long cid) {
        return exec("DB: получение записи из таблицы ppc.camp_metrika_goals",
                db -> db.selectFrom(CAMP_METRIKA_GOALS)
                        .where(CAMP_METRIKA_GOALS.CID.eq(cid))
                        .fetch());
    }

    public void addOrUpdateMetrikaGoals(Long campaignId, Long goalId, Long goalsCount, Long contextGoalsCount) {
        CampMetrikaGoalsRecord record = new CampMetrikaGoalsRecord()
                .setCid(campaignId)
                .setGoalId(goalId)
                .setGoalsCount(goalsCount)
                .setContextGoalsCount(contextGoalsCount);
        addOrUpdateMetrikaGoals(record);
    }

    @Step("DB: добавление или изменение цели в таблице ppc.ppc.camp_metrika_goals")
    public void addOrUpdateMetrikaGoals(CampMetrikaGoalsRecord campMetrikaGoalsRecord) {
        run(db -> db.insertInto(CAMP_METRIKA_GOALS)
                .set(campMetrikaGoalsRecord)
                .onDuplicateKeyUpdate()
                .set(campMetrikaGoalsRecord)
                .execute());
    }
}
