package ru.yandex.autotests.direct.db.steps;

import java.util.List;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampOperationsQueueCopyRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.autotests.irt.testutils.allure.AllureUtils;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.CampOperationsQueueCopy.CAMP_OPERATIONS_QUEUE_COPY;
import static ru.yandex.autotests.direct.utils.beans.BeanWrapper.wrap;

public class CampOperationsQueueCopySteps extends BasePpcSteps {

    @Step("DB: изменение записи в таблице ppc.camp_operations_queue_copy")
    public void updateCampOperationsQueueCopyRecord(CampOperationsQueueCopyRecord campOperationsQueueCopyRecord) {
        run(db -> db.update(CAMP_OPERATIONS_QUEUE_COPY)
                .set(campOperationsQueueCopyRecord)
                .where(CAMP_OPERATIONS_QUEUE_COPY.ID.eq(campOperationsQueueCopyRecord.getId()))
                .execute()
        );
    }

    @Step("DB: получение записей из таблицы ppc.camp_operations_queue_copy")
    public List<CampOperationsQueueCopyRecord> getCampOperationsQueueCopyRecords(Long... cids) {
        AllureUtils.addTextAttachment("cids", wrap(cids).toString());
        return exec(db -> db.selectFrom(CAMP_OPERATIONS_QUEUE_COPY)
                .where(CAMP_OPERATIONS_QUEUE_COPY.CID.in(cids))
                .fetch());
    }
}
