package ru.yandex.autotests.direct.db.steps;

import java.util.List;

import org.jooq.DatePart;
import org.jooq.impl.DSL;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampOperationsQueueRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.autotests.irt.testutils.allure.AllureUtils;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.CAMP_OPERATIONS_QUEUE;
import static ru.yandex.autotests.direct.utils.beans.BeanWrapper.wrap;

public class CampOperationsQueueSteps extends BasePpcSteps {
    @Step("DB: изменение записи в таблице ppc.camp_operations_queue")
    public void updateCampOperationsQueueRecord(CampOperationsQueueRecord campOperationsQueueRecord) {
        run(db -> db.update(CAMP_OPERATIONS_QUEUE)
                .set(campOperationsQueueRecord)
                .where(CAMP_OPERATIONS_QUEUE.CID.eq(campOperationsQueueRecord.getCid()))
                .execute()
        );
    }

    @Step("DB: создание записи в таблице ppc.camp_operations_queue")
    public void saveCampOperationsQueueRecord(CampOperationsQueueRecord campOperationsQueueRecord) {
        run(db -> db.insertInto(CAMP_OPERATIONS_QUEUE)
                .set(campOperationsQueueRecord)
                .execute()
        );
    }

    @Step("DB: получение записей из таблицы ppc.camp_operations_queue")
    public List<CampOperationsQueueRecord> getCampOperationsQueueRecords(Long... cids) {
        AllureUtils.addTextAttachment("cids", wrap(cids).toString());
        return exec(db -> db.selectFrom(CAMP_OPERATIONS_QUEUE)
                .where(CAMP_OPERATIONS_QUEUE.CID.in(cids))
                .fetch());
    }

    @Step("DB: двигаем кампнию назад в очереди асинхронных операций")
    public void moveBack(Long cid) {
        run(db -> db.update(CAMP_OPERATIONS_QUEUE)
                .set(CAMP_OPERATIONS_QUEUE.QUEUE_TIME,
                        DSL.timestampAdd(CAMP_OPERATIONS_QUEUE.QUEUE_TIME, -70, DatePart.DAY))
                .where(CAMP_OPERATIONS_QUEUE.CID.eq(cid))
                .execute()
        );
    }
}
