package ru.yandex.autotests.direct.db.steps;

import java.sql.Timestamp;

import ru.yandex.autotests.direct.db.models.jooq.ppc.Tables;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.CampDayBudgetStopHistory.CAMP_DAY_BUDGET_STOP_HISTORY;


public class CampStopStatSteps extends BasePpcSteps {

    @Step("DB: Удаление записи в таблице ppc.camp_day_budget_stop_history")
    public void deleteCampStopStat(Long cid) {
        run(db -> db.deleteFrom(Tables.CAMP_DAY_BUDGET_STOP_HISTORY)
                .where(CAMP_DAY_BUDGET_STOP_HISTORY.CID.eq(cid))
                .execute()
        );
    }
    @Step("DB: Добавление записи в таблицу ppc.camp_day_budget_stop_history")
    public void createCampStopStat(Long cid, Timestamp stopDate) {
        run(db -> db.insertInto(Tables.CAMP_DAY_BUDGET_STOP_HISTORY)
                .set(CAMP_DAY_BUDGET_STOP_HISTORY.CID, cid)
                .set(CAMP_DAY_BUDGET_STOP_HISTORY.STOP_TIME, stopDate)
                .execute()
        );
    }
}
