package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.CAMPAIGNS_DEALS;


public class CampaignDealsSteps extends BasePpcSteps {

    @Step("DB: Привязка сделки {0} к кампании {1}")
    public void addCampaignDeal(Long dealId, Long cid, Integer isDeleted) {
        run(db -> db.insertInto(CAMPAIGNS_DEALS)
                .set(CAMPAIGNS_DEALS.CID, cid)
                .set(CAMPAIGNS_DEALS.DEAL_ID, dealId)
                .set(CAMPAIGNS_DEALS.IS_DELETED, isDeleted)
                .onDuplicateKeyIgnore()
                .execute()
        );
    }
}
