package ru.yandex.autotests.direct.db.steps;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsInternalRestrictionType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsInternalRfCloseByClick;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsInternalRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.CAMPAIGNS_INTERNAL;

@ParametersAreNonnullByDefault
public class CampaignsInternalSteps extends BasePpcSteps {

    @Step("DB: получение записи из таблицы ppc.campaigns_internal (cid:{0}")
    public CampaignsInternalRecord getCampaignsInternalRecord(Long cid) {
        return exec(db -> db.selectFrom(CAMPAIGNS_INTERNAL)
                .where(CAMPAIGNS_INTERNAL.CID.eq(cid))
                .fetchOne());
    }

    @Step("DB: обновление записи в таблице ppc.campaigns_internal ")
    public void updateCampaignsInternalRecord(CampaignsInternalRecord campaignsInternal) {
        run(db -> db.update(CAMPAIGNS_INTERNAL)
                .set(campaignsInternal)
                .where(CAMPAIGNS_INTERNAL.CID.eq(campaignsInternal.getCid()))
                .execute());
    }

    @Step("DB: установка is_mobile в таблице ppc.campaigns_internal (cid:{0}, is_mobile: {1})")
    public void setIsMobile(Long cid, Integer isMobile) {
        run(db -> db.update(CAMPAIGNS_INTERNAL)
                .set(CAMPAIGNS_INTERNAL.IS_MOBILE, isMobile)
                .where(CAMPAIGNS_INTERNAL.CID.eq(cid))
                .execute());
    }

    @Step("DB: установка page_ids в таблице ppc.campaigns_internal (cid:{0}, page_ids: {1})")
    public void setPageIds(Long cid, String pageIds) {
        run(db -> db.update(CAMPAIGNS_INTERNAL)
                .set(CAMPAIGNS_INTERNAL.PAGE_IDS, pageIds)
                .where(CAMPAIGNS_INTERNAL.CID.eq(cid))
                .execute());
    }

    @Step("DB: установка place_id в таблице ppc.campaigns_internal (cid:{0}, place_id: {1})")
    public void setPlaceId(Long cid, Long placeId) {
        run(db -> db.update(CAMPAIGNS_INTERNAL)
                .set(CAMPAIGNS_INTERNAL.PLACE_ID, placeId)
                .where(CAMPAIGNS_INTERNAL.CID.eq(cid))
                .execute());
    }

    @Step("DB: установка restriction_type в таблице ppc.campaigns_internal (cid:{0}, restriction_type: {1})")
    public void setRestrictionType(Long cid, CampaignsInternalRestrictionType restrictionType) {
        run(db -> db.update(CAMPAIGNS_INTERNAL)
                .set(CAMPAIGNS_INTERNAL.RESTRICTION_TYPE, restrictionType)
                .where(CAMPAIGNS_INTERNAL.CID.eq(cid))
                .execute());
    }

    @Step("DB: установка restriction_value в таблице ppc.campaigns_internal (cid:{0}, restriction_value: {1})")
    public void setRestrictionValue(Long cid, Long restrictionValue) {
        run(db -> db.update(CAMPAIGNS_INTERNAL)
                .set(CAMPAIGNS_INTERNAL.RESTRICTION_VALUE, restrictionValue)
                .where(CAMPAIGNS_INTERNAL.CID.eq(cid))
                .execute());
    }

    @Step("DB: установка rotation_goal_id в таблице ppc.campaigns_internal (cid:{0}, rotation_goal_id: {1})")
    public void setRotationGoalId(Long cid, Long rotationGoalId) {
        run(db -> db.update(CAMPAIGNS_INTERNAL)
                .set(CAMPAIGNS_INTERNAL.ROTATION_GOAL_ID, rotationGoalId)
                .where(CAMPAIGNS_INTERNAL.CID.eq(cid))
                .execute());
    }

    @Step("DB: установка rf_close_by_click в таблице ppc.campaigns_internal (cid:{0}, rf_close_by_click: {1})")
    public void setRfCloseByClick(Long cid, CampaignsInternalRfCloseByClick rfCloseByClick) {
        run(db -> db.update(CAMPAIGNS_INTERNAL)
                .set(CAMPAIGNS_INTERNAL.RF_CLOSE_BY_CLICK, rfCloseByClick)
                .where(CAMPAIGNS_INTERNAL.CID.eq(cid))
                .execute());
    }

}
