package ru.yandex.autotests.direct.db.steps;

import java.sql.Date;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsPromotionsRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.CAMPAIGNS_PROMOTIONS;

public class CampaignsPromotionsSteps extends BasePpcSteps {

    @Step("DB: добавление записи в таблицу ppc.campaigns_promotions")
    public Long addCampaignsPromotions(Long cid, Date start, Date finish, Short percent) {
        Long promotionId = autoIncSteps().getNewCampaignsPromotionId();
        CampaignsPromotionsRecord campaignsPromotionsRecord = new CampaignsPromotionsRecord();
        campaignsPromotionsRecord.setCid(cid);
        campaignsPromotionsRecord.setPromotionId(promotionId);
        campaignsPromotionsRecord.setStart(start);
        campaignsPromotionsRecord.setFinish(finish);
        campaignsPromotionsRecord.setPercent(percent);
        run(db -> db.insertInto(CAMPAIGNS_PROMOTIONS)
                .set(campaignsPromotionsRecord)
                .execute());
        return promotionId;
    }
}
