package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.ClientLimitsRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.CLIENT_LIMITS;

public class ClientLimitsSteps extends BasePpcSteps {

    @Step("DB: получение записи из таблицы ppc.client_limits (clientId = {0})")
    public ClientLimitsRecord getClientLimits(Long clientId) {
        return exec(db -> db.selectFrom(CLIENT_LIMITS)
                .where(CLIENT_LIMITS.CLIENTID.eq(clientId))
                .fetchOne());
    }
    @Step("DB: создание или обновление записи в таблице ppc.client_limits")
    public void addOrUpdateClientLimits(ClientLimitsRecord clientLimits) {
        run(db -> db.insertInto(CLIENT_LIMITS)
                .set(CLIENT_LIMITS.CLIENTID, clientLimits.getClientid())
                .set(CLIENT_LIMITS.BANNER_COUNT_LIMIT, clientLimits.getBannerCountLimit())
                .set(CLIENT_LIMITS.CAMP_COUNT_LIMIT, clientLimits.getCampCountLimit())
                .set(CLIENT_LIMITS.FEED_COUNT_LIMIT, clientLimits.getFeedCountLimit())
                .set(CLIENT_LIMITS.FEED_MAX_FILE_SIZE, clientLimits.getFeedMaxFileSize())
                .set(CLIENT_LIMITS.KEYWORD_COUNT_LIMIT, clientLimits.getKeywordCountLimit())
                .set(CLIENT_LIMITS.UNARC_CAMP_COUNT_LIMIT, clientLimits.getUnarcCampCountLimit())
                .onDuplicateKeyUpdate()
                .set(CLIENT_LIMITS.BANNER_COUNT_LIMIT, clientLimits.getBannerCountLimit())
                .set(CLIENT_LIMITS.CAMP_COUNT_LIMIT, clientLimits.getCampCountLimit())
                .set(CLIENT_LIMITS.FEED_COUNT_LIMIT, clientLimits.getFeedCountLimit())
                .set(CLIENT_LIMITS.FEED_MAX_FILE_SIZE, clientLimits.getFeedMaxFileSize())
                .set(CLIENT_LIMITS.KEYWORD_COUNT_LIMIT, clientLimits.getKeywordCountLimit())
                .set(CLIENT_LIMITS.UNARC_CAMP_COUNT_LIMIT, clientLimits.getUnarcCampCountLimit())
                .execute());
    }

    @Step("DB: обновление поля keyword_count_limit ppc.client_limits (clientId = {0}, keywordCount = {1})")
    public void addOrUpdateClientLimitsKeywordCount(Long clientId, Long keywordCount) {
        ClientLimitsRecord clientLimits = new ClientLimitsRecord();
        clientLimits.setClientid(clientId);
        clientLimits.setKeywordCountLimit(keywordCount);
        clientLimits.setBannerCountLimit(0L);
        clientLimits.setCampCountLimit(0L);
        clientLimits.setFeedCountLimit(0L);
        clientLimits.setUnarcCampCountLimit(0L);
        clientLimits.setFeedMaxFileSize(0L);

        addOrUpdateClientLimits(clientLimits);
    }


}
