package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.ClientPixelProvidersCriterionType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.ClientPixelProvidersProvider;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.ClientPixelProviders;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.enums.ClientPixelProvidersCampaignType.cpm_banner;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.enums.ClientPixelProvidersCampaignType.cpm_deals;

public class ClientPixelProvidersSteps extends BasePpcSteps {

    @Step("DB: добавление записей в таблицу CLIENT_PIXEL_PROVIDERS")
    public void addClientPixelProvider(Long clientId, CampaignsType campaignsType,
            ClientPixelProvidersCriterionType clientPixelProvidersCriterionType,
            ClientPixelProvidersProvider clientPixelProvidersProvider)
    {
        run(db -> db.insertInto(ClientPixelProviders.CLIENT_PIXEL_PROVIDERS)
                .set(ClientPixelProviders.CLIENT_PIXEL_PROVIDERS.CLIENTID, clientId)
                .set(ClientPixelProviders.CLIENT_PIXEL_PROVIDERS.CAMPAIGN_TYPE,
                        campaignsType == CampaignsType.cpm_deals ? cpm_deals : cpm_banner)
                .set(ClientPixelProviders.CLIENT_PIXEL_PROVIDERS.CRITERION_TYPE,
                        clientPixelProvidersCriterionType)
                .set(ClientPixelProviders.CLIENT_PIXEL_PROVIDERS.PROVIDER,
                        clientPixelProvidersProvider)
                .onDuplicateKeyIgnore()
                .execute()
        );

    }

    @Step("DB: удаление разрешённых клиенту {0} пикселей аудита")
    public void deleteClientProviders(Long clientId) {
        run(db -> db.deleteFrom(ClientPixelProviders.CLIENT_PIXEL_PROVIDERS)
                .where(ClientPixelProviders.CLIENT_PIXEL_PROVIDERS.CLIENTID.eq(clientId))
                .execute()
        );
    }
}
