package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.ClientTeaserDataLastupdateRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.ClientTeaserDataLastupdate.CLIENT_TEASER_DATA_LASTUPDATE;

/**
 * Created by buhter on 30/05/16.
 */
public class ClientTeaserDataLastupdateSteps extends BasePpcSteps {

    @Step("DB: получение записи из таблицы ppc.client_teaser_data_lastupdate (clientId = {0})")
    public ClientTeaserDataLastupdateRecord getClientTeaserDataLastupdate(Long clientId) {
        return exec(db -> db.selectFrom(CLIENT_TEASER_DATA_LASTUPDATE)
                .where(CLIENT_TEASER_DATA_LASTUPDATE.CLIENTID.eq(clientId))
                .fetchOne());
    }

    @Step("DB: создание записи в таблице ppc.client_teaser_data_lastupdate")
    public void createClientTeaserDataLastupdate(ClientTeaserDataLastupdateRecord record) {
        exec(db -> db.insertInto(CLIENT_TEASER_DATA_LASTUPDATE)
                .set(record)
                .execute());
    }

}
