package ru.yandex.autotests.direct.db.steps;

import java.util.Optional;

import org.jooq.Record1;

import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.ClientsApiOptionsApiEnabled;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.ClientsApiOptionsRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.enums.ClientsApiOptionsApiEnabled.Yes;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.ClientsApiOptions.CLIENTS_API_OPTIONS;

public class ClientsApiOptionsSteps extends BasePpcSteps {

    @Step("DB: Получение записи из таблицы ppc.clients_api_options по clientid: {0}")
    public ClientsApiOptionsRecord getOptions(Long clientId) {
        return exec(db -> db.selectFrom(CLIENTS_API_OPTIONS)
                .where(CLIENTS_API_OPTIONS.CLIENTID.eq(clientId))
                .fetchOne());
    }

    @Step("DB: обновление записи в ppc.clients_api_options")
    public void createOptions(ClientsApiOptionsRecord record) {
        exec(db -> db.insertInto(CLIENTS_API_OPTIONS)
                .set(record)
                .execute());
    }

    @Step("DB: Получение суточного лимита баллов из ppc.clients_api_options по clientid: {0}")
    public Long getUnitsDaily(Long clientId) {
        return Optional.ofNullable(
                exec(db -> db.select(CLIENTS_API_OPTIONS.API5_UNITS_DAILY)
                        .from(CLIENTS_API_OPTIONS)
                        .where(CLIENTS_API_OPTIONS.CLIENTID.eq(clientId))
                        .fetchOne()))
                .map(Record1::value1)
                .orElse(0L);
    }

    @Step("DB: Обновление или создание суточного лимита баллов в ppc.clients_api_options по clientid: {0}")
    public void setUnitsDaily(Long clientId, Long unitsDaily) {
        exec(db -> db.insertInto(CLIENTS_API_OPTIONS)
                .set(new ClientsApiOptionsRecord(clientId, Yes, unitsDaily))
                .onDuplicateKeyUpdate()
                .set(CLIENTS_API_OPTIONS.API5_UNITS_DAILY, unitsDaily)
                .execute()
        );
    }

    @Step("DB: Отключить доступ к API по clientid: {0}")
    public void disableApiAccess(Long clientId) {
        exec(db -> db.insertInto(CLIENTS_API_OPTIONS)
                .set(CLIENTS_API_OPTIONS.CLIENTID, clientId)
                .set(CLIENTS_API_OPTIONS.API_ENABLED, ClientsApiOptionsApiEnabled.No)
                .set(CLIENTS_API_OPTIONS.API5_UNITS_DAILY, 10000L)
                .onDuplicateKeyUpdate()
                .set(CLIENTS_API_OPTIONS.API_ENABLED, ClientsApiOptionsApiEnabled.No)
                .execute()
        );
    }
}
