package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.ClientsCustomOptionsRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.CLIENTS_CUSTOM_OPTIONS;
import static ru.yandex.autotests.irt.testutils.allure.AllureUtils.addJsonAttachment;

public class ClientsCustomOptionsSteps extends BasePpcSteps {
    @Step("DB: изменение записи в таблице ppc.clients_custom_options (record = {0})")
    public void updateClientsCustomOptions(ClientsCustomOptionsRecord record) {
        String logRecord = JsonUtils.toStringLow(record.intoMap());
        getLogger().info("Обновление записи в таблице ppc.clients_custom_options: " + logRecord);
        addJsonAttachment("Обновлённая запись", logRecord);
        run(db -> db.update(CLIENTS_CUSTOM_OPTIONS)
                .set(CLIENTS_CUSTOM_OPTIONS.VALUE, record.getValue())
                .where(CLIENTS_CUSTOM_OPTIONS.CLIENTID.eq(record.getClientid())
                        .and(CLIENTS_CUSTOM_OPTIONS.KEYNAME.eq(record.getKeyname()))
                ).execute());
    }

    @Step("DB: создание записи в таблице ppc.clients_custom_options (record = {0})")
    public void saveClientsCustomOptions(ClientsCustomOptionsRecord record) {
        String logRecord = JsonUtils.toStringLow(record.intoMap());
        getLogger().info("новая запись в таблице ppc.clients_custom_options: " + logRecord);
        addJsonAttachment("новая запись", logRecord);
        run(db -> db.insertInto(CLIENTS_CUSTOM_OPTIONS)
                .columns(CLIENTS_CUSTOM_OPTIONS.CLIENTID, CLIENTS_CUSTOM_OPTIONS.KEYNAME, CLIENTS_CUSTOM_OPTIONS.VALUE)
                .values(record.getClientid(), record.getKeyname(), record.getValue())
                .execute());
    }
}
