package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.ClientsAllowCreateScampBySubclient;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.ClientsWorkCurrency;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.ClientsFeaturesRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.ClientsRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.IDM_GROUP_ROLES;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.Clients.CLIENTS;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.ClientsFeatures.CLIENTS_FEATURES;

/**
 * Created by buhter on 15/09/16.
 */
public class ClientsSteps extends BasePpcSteps {

    @Step("DB: получение записи из таблицы ppc.clients по ClientID:{0}")
    public ClientsRecord getClients(Long clientID) {
        return exec(db -> db.selectFrom(CLIENTS)
                .where(CLIENTS.CLIENTID.eq(clientID))
                .fetchOne());
    }


    @Step("DB: получение записи из таблицы ppc.clients_features по ClientID:{0} и FeatureId:{1}")
    public ClientsFeaturesRecord getClientsFeature(Long clientID, Long featureId) {
        return exec(db -> db.selectFrom(CLIENTS_FEATURES)
                .where(CLIENTS_FEATURES.CLIENTID.eq(clientID).and(CLIENTS_FEATURES.FEATURE_ID.eq(featureId)))
                .fetchOne());
    }

    @Step("DB: установка клиенту ClientID: {0} фичи id: {1} в значение {2}")
    public void setClientFeature(Long clientID, long featureId, boolean featureEnabled) {
        run(db -> db.insertInto(CLIENTS_FEATURES)
                .set(CLIENTS_FEATURES.CLIENTID, clientID)
                .set(CLIENTS_FEATURES.FEATURE_ID, featureId)
                .set(CLIENTS_FEATURES.IS_ENABLED, featureEnabled ? 1 : 0)
                .onDuplicateKeyUpdate()
                .set(CLIENTS_FEATURES.IS_ENABLED, featureEnabled ? 1 : 0)
                .execute());
    }

    @Step("DB: проверка включенности фичи {1} для клиента ClientID: {0}")
    public boolean isFeatureEnabled(Long clientId, long featureId) {
        ClientsFeaturesRecord feature = getClientsFeature(clientId, featureId);
        return feature != null && !feature.getIsEnabled().equals(0);
    }

    @Step("DB: добавление доступа к клиенту {0} для idm-группы {1}")
    public void addIdmGroupAccess(Long clientID, Long idmGroupId) {
        run(db -> db.insertInto(IDM_GROUP_ROLES)
                .set(IDM_GROUP_ROLES.SUBJECT_CLIENTID, clientID)
                .set(IDM_GROUP_ROLES.IDM_GROUP_ID, idmGroupId)
                .onDuplicateKeyIgnore()
                .execute());
    }

    @Step("DB: удаление доступа к клиенту {0} для idm-группы {1}")
    public void removeIdmGroupAccess(Long clientID, Long idmGroupId) {
        run(db -> db.deleteFrom(IDM_GROUP_ROLES)
                .where(IDM_GROUP_ROLES.SUBJECT_CLIENTID.eq(clientID)
                        .and(IDM_GROUP_ROLES.IDM_GROUP_ID.eq(idmGroupId)))
                .execute());
    }

    @Step("DB: установка IDM-\"главного менеджера\" uid:{1} для клиента {0}")
    public void setIdmPrimaryManager(Long clientID, Long primaryManagerUid) {
        run(db -> db.update(CLIENTS)
                .set(CLIENTS.PRIMARY_MANAGER_UID, primaryManagerUid)
                .set(CLIENTS.PRIMARY_MANAGER_SET_BY_IDM, 1)
                .where(CLIENTS.CLIENTID.eq(clientID))
                .execute());
    }

    @Step("DB: очистка IDM-\"главного менеджера\" uid:{1} для клиента {0}")
    public void clearIdmPrimaryManager(Long clientID) {
        run(db -> db.update(CLIENTS)
                .set(CLIENTS.PRIMARY_MANAGER_UID, (Long) null)
                .set(CLIENTS.PRIMARY_MANAGER_SET_BY_IDM, 0)
                .where(CLIENTS.CLIENTID.eq(clientID))
                .execute());
    }

    @Step("DB: выставление в записи из таблицы ppc.clients по ClientID: {0}, work_currency:{1} ")
    public void setClientsWorkCurrency(Long clientID, ClientsWorkCurrency workCurrency) {
        run(db -> db.update(CLIENTS)
                .set(CLIENTS.WORK_CURRENCY, workCurrency)
                .where(CLIENTS.CLIENTID.eq(clientID))
                .execute());
    }

    @Step("DB: выставление в записи из таблицы ppc.clients по ClientID: {0}, allowCreateScampBySubclient:{1} ")
    public void setFree(Long clientID, ClientsAllowCreateScampBySubclient allowCreateScampBySubclient) {
        run(db -> db.update(CLIENTS)
                .set(CLIENTS.ALLOW_CREATE_SCAMP_BY_SUBCLIENT, allowCreateScampBySubclient)
                .where(CLIENTS.CLIENTID.eq(clientID))
                .execute());
    }

    @Step("DB: удаление записи из таблицы ppc.clients по ClientID: {0}")
    public void deleteClientFromClientsTable(long clientId) {
        run(db -> db
                .deleteFrom(CLIENTS)
                .where(CLIENTS.CLIENTID.eq(clientId))
                .execute());
    }
}
