package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.ClientsToForceMulticurrencyTeaserRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.ClientsToForceMulticurrencyTeaser.CLIENTS_TO_FORCE_MULTICURRENCY_TEASER;

/**
 * Created by buhter on 27/05/16.
 */
public class ClientsToForceMulticurrencyTeaserSteps extends BasePpcSteps {
    @Step("DB: получение записи из таблицы ppc.clients_to_force_multicurrency_teaser (clientId = {0})")
    public ClientsToForceMulticurrencyTeaserRecord getClientsToForceMulticurrencyTeaser(Long clientId) {
        return exec(db -> db.selectFrom(CLIENTS_TO_FORCE_MULTICURRENCY_TEASER)
                .where(CLIENTS_TO_FORCE_MULTICURRENCY_TEASER.CLIENTID.eq(clientId))
                .fetchOne());
    }

    @Step("DB: создание записи в таблице ppc.clients_to_force_multicurrency_teaser")
    public void createClientsToForceMulticurrencyTeaser(Long clientId, int modifyConvertAllowed) {
        ClientsToForceMulticurrencyTeaserRecord record =
                new ClientsToForceMulticurrencyTeaserRecord(clientId, modifyConvertAllowed);
        exec(db -> db.insertInto(CLIENTS_TO_FORCE_MULTICURRENCY_TEASER)
                .set(record)
                .execute());
    }

    @Step("DB: создание записи в таблице ppc.clients_to_force_multicurrency_teaser")
    public void createClientsToForceMulticurrencyTeaser(ClientsToForceMulticurrencyTeaserRecord record) {
        exec(db -> db.insertInto(CLIENTS_TO_FORCE_MULTICURRENCY_TEASER)
                .set(record)
                .execute());
    }
}
