package ru.yandex.autotests.direct.db.steps;

import java.math.BigInteger;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.ContentPromotionRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.BANNERS_CONTENT_PROMOTION;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.CONTENT_PROMOTION;

public class ContentPromotionSteps extends BasePpcSteps {

    public static final String DEFAULT_METADATA = "{\"Title\": \"a title\", \"Passage\": \"a description\"}";

    @Step("DB: добавление записи в таблицу ppc.content_promotion по content_promotion_id: {0}")
    public long addDefaultContentPromotion(Long clientId) {
        return addDefaultContentPromotion(clientId, DEFAULT_METADATA);
    }

    @Step("DB: добавление записи в таблицу ppc.content_promotion по content_promotion_id: {0}")
    public long addDefaultContentPromotion(Long clientId, String metadata) {
        long id = super.autoIncSteps().getNewContentPromotionId();
        exec(db -> db.insertInto(CONTENT_PROMOTION)
                .set(CONTENT_PROMOTION.ID, id)
                .set(CONTENT_PROMOTION.CLIENTID, clientId)
                .set(CONTENT_PROMOTION.URL, "https://www.youtube.com/434325")
                .set(CONTENT_PROMOTION.EXTERNAL_ID, Long.toString(id))
                .set(CONTENT_PROMOTION.METADATA, metadata)
                .set(CONTENT_PROMOTION.METADATA_HASH, BigInteger.ONE)
                .onDuplicateKeyUpdate()
                .set(CONTENT_PROMOTION.METADATA, metadata)
                .execute());
        return id;
    }

    @Step("DB: получение записи из таблицы ppc.content_promotion по content_promotion_id: {0} и clientId: {1}")
    public ContentPromotionRecord getContentPromotion(Long contentPromotionId, Long clientId) {
        return exec(db -> db.selectFrom(CONTENT_PROMOTION)
                .where(CONTENT_PROMOTION.ID.eq(contentPromotionId))
                .and(CONTENT_PROMOTION.CLIENTID.eq(clientId))
                .fetchOne());
    }

    @Step("DB: получение записи из таблицы ppc.content_promotion по clientId: {0}")
    public ContentPromotionRecord getContentPromotion(Long clientId) {
        return exec(db -> db.selectFrom(CONTENT_PROMOTION)
                .where(CONTENT_PROMOTION.CLIENTID.eq(clientId))
                .fetchOne());
    }

    @Step("DB: удаление записи из таблицы ppc.content_promotion по content_promotion_id: {0} и clientId: {1}")
    public int deleteContentPromotion(Long contentPromotionId) {
        return exec(db -> db.deleteFrom(CONTENT_PROMOTION)
                .where(CONTENT_PROMOTION.ID.eq(contentPromotionId))
                .execute());
    }

    @Step("DB: добавление записи в таблицу ppc.content_promotion по bid: {0} и content_promotion_id: {1}")
    public int addContentPromotionToBanner(Long bannerId, Long contentPromotionId) {
        return exec(db -> db.insertInto(BANNERS_CONTENT_PROMOTION)
                .set(BANNERS_CONTENT_PROMOTION.BID, bannerId)
                .set(BANNERS_CONTENT_PROMOTION.CONTENT_PROMOTION_ID, contentPromotionId)
                .onDuplicateKeyUpdate()
                .set(BANNERS_CONTENT_PROMOTION.BID, bannerId)
                .set(BANNERS_CONTENT_PROMOTION.CONTENT_PROMOTION_ID, contentPromotionId)
                .execute());
    }

    @Step("DB: добавление записи в таблицу ppc.content_promotion по bid: {0} и content_promotion_id: {1}, содержит visit_url: {2}")
    public int addContentPromotionToBanner(Long bannerId, Long contentPromotionId, String visitUrl) {
        return exec(db -> db.insertInto(BANNERS_CONTENT_PROMOTION)
                .set(BANNERS_CONTENT_PROMOTION.BID, bannerId)
                .set(BANNERS_CONTENT_PROMOTION.CONTENT_PROMOTION_ID, contentPromotionId)
                .set(BANNERS_CONTENT_PROMOTION.VISIT_URL, visitUrl)
                .onDuplicateKeyUpdate()
                .set(BANNERS_CONTENT_PROMOTION.BID, bannerId)
                .set(BANNERS_CONTENT_PROMOTION.CONTENT_PROMOTION_ID, contentPromotionId)
                .set(BANNERS_CONTENT_PROMOTION.VISIT_URL, visitUrl)
                .execute());
    }

    @Step("DB: изменение значения поле is_inaccessible на {1} по id: {0}")
    public int setContentPromotionInaccessible(Long contentPromotionId, int isInaccessible) {
        return exec(db -> db.update(CONTENT_PROMOTION)
                .set(CONTENT_PROMOTION.IS_INACCESSIBLE, isInaccessible)
                .where(CONTENT_PROMOTION.ID.eq(contentPromotionId))
                .execute()
        );
    }
}
