package ru.yandex.autotests.direct.db.steps;

import java.math.BigInteger;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.ContentPromotionVideoRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.BANNERS_CONTENT_PROMOTION_VIDEO;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.CONTENT_PROMOTION_VIDEO;

public class ContentPromotionVideoSteps extends BasePpcSteps {

    public static final String DEFAULT_METADATA = "{\"Title\": \"a title\", \"Passage\": [\"a description\"]}";

    @Step("DB: добавление записи в таблицу ppc.content_promotion_video по content_promotion_video_id: {0}")
    public int addDefaultContentPromotionVideo(Long contentPromotionVideoId, Long clientId) {
        return addDefaultContentPromotionVideo(contentPromotionVideoId, clientId, DEFAULT_METADATA);
    }

    @Step("DB: добавление записи в таблицу ppc.content_promotion_video по content_promotion_video_id: {0}")
    public int addDefaultContentPromotionVideo(Long contentPromotionVideoId, Long clientId, String metadata) {
        return exec(db -> db.insertInto(CONTENT_PROMOTION_VIDEO)
                .set(CONTENT_PROMOTION_VIDEO.CONTENT_PROMOTION_VIDEO_ID, BigInteger.valueOf(contentPromotionVideoId))
                .set(CONTENT_PROMOTION_VIDEO.CLIENTID, clientId)
                .set(CONTENT_PROMOTION_VIDEO.VIDEO_HREF, "https://www.youtube.com/434325")
                .set(CONTENT_PROMOTION_VIDEO.VIDEO_HREF_HASH, BigInteger.ONE)
                .set(CONTENT_PROMOTION_VIDEO.VIDEO_METADATA, metadata)
                .set(CONTENT_PROMOTION_VIDEO.VIDEO_METADATA_HASH, BigInteger.ONE)
                .onDuplicateKeyUpdate()
                .set(CONTENT_PROMOTION_VIDEO.CLIENTID, clientId)
                .set(CONTENT_PROMOTION_VIDEO.VIDEO_METADATA, metadata)
                .execute()
        );
    }

    @Step("DB: получение записи из таблицы ppc.content_promotion_video по content_promotion_video_id: {0} и clientId: {1}")
    public ContentPromotionVideoRecord getContentPromotionVideo(Long contentPromotionVideoId, Long clientId) {
        return exec(db -> db.selectFrom(CONTENT_PROMOTION_VIDEO)
                .where(CONTENT_PROMOTION_VIDEO.CONTENT_PROMOTION_VIDEO_ID.eq(BigInteger.valueOf(contentPromotionVideoId)))
                .and(CONTENT_PROMOTION_VIDEO.CLIENTID.eq(clientId))
                .fetchOne()
        );
    }

    @Step("DB: получение записи из таблицы ppc.content_promotion_video по clientId: {0}")
    public ContentPromotionVideoRecord getContentPromotionVideo(Long clientId) {
        return exec(db -> db.selectFrom(CONTENT_PROMOTION_VIDEO)
                .where(CONTENT_PROMOTION_VIDEO.CLIENTID.eq(clientId))
                .fetchOne()
        );
    }

    @Step("DB: удаление записи из таблицы ppc.content_promotion_video по content_promotion_video_id: {0} и clientId: {1}")
    public int deleteContentPromotionVideo(Long contentPromotionVideoId, Long clientId) {
        return exec(db -> db.deleteFrom(CONTENT_PROMOTION_VIDEO)
                .where(CONTENT_PROMOTION_VIDEO.CONTENT_PROMOTION_VIDEO_ID.eq(BigInteger.valueOf(contentPromotionVideoId)))
                .and(CONTENT_PROMOTION_VIDEO.CLIENTID.eq(clientId))
                .execute());
    }

    @Step("DB: добавление записи в таблицу ppc.content_promotion_video по bid: {0} и content_promotion_video_id: {1}")
    public int addContentPromotionVideoToBanner(Long bannerId, Long contentPromotionVideoId) {
        return exec(db -> db.insertInto(BANNERS_CONTENT_PROMOTION_VIDEO)
                .set(BANNERS_CONTENT_PROMOTION_VIDEO.BID, bannerId)
                .set(BANNERS_CONTENT_PROMOTION_VIDEO.CONTENT_PROMOTION_VIDEO_ID, BigInteger.valueOf(contentPromotionVideoId))
                .onDuplicateKeyUpdate()
                .set(BANNERS_CONTENT_PROMOTION_VIDEO.BID, bannerId)
                .set(BANNERS_CONTENT_PROMOTION_VIDEO.CONTENT_PROMOTION_VIDEO_ID, BigInteger.valueOf(contentPromotionVideoId))
                .execute()
        );
    }

    @Step("DB: изменение значения поле is_inaccessible на {1} по content_promotion_video_id: {0}")
    public int setContentPromotionVideoInaccessible(Long contentPromotionVideoId, int isInaccessible) {
        return exec(db -> db.update(CONTENT_PROMOTION_VIDEO)
                .set(CONTENT_PROMOTION_VIDEO.IS_INACCESSIBLE, isInaccessible)
                .where(CONTENT_PROMOTION_VIDEO.CONTENT_PROMOTION_VIDEO_ID.eq(BigInteger.valueOf(contentPromotionVideoId)))
                .execute()
        );
    }

    @Step("DB: добавление записи в таблицу ppc.content_promotion_video по bid: {0} и content_promotion_video_id: {1}, содержит packshot_href: {2}")
    public int addContentPromotionVideoToBanner(Long bannerId, Long contentPromotionVideoId, String packshotHref) {
        return exec(db -> db.insertInto(BANNERS_CONTENT_PROMOTION_VIDEO)
                .set(BANNERS_CONTENT_PROMOTION_VIDEO.BID, bannerId)
                .set(BANNERS_CONTENT_PROMOTION_VIDEO.CONTENT_PROMOTION_VIDEO_ID, BigInteger.valueOf(contentPromotionVideoId))
                .set(BANNERS_CONTENT_PROMOTION_VIDEO.PACKSHOT_HREF, packshotHref)
                .onDuplicateKeyUpdate()
                .set(BANNERS_CONTENT_PROMOTION_VIDEO.BID, bannerId)
                .set(BANNERS_CONTENT_PROMOTION_VIDEO.CONTENT_PROMOTION_VIDEO_ID, BigInteger.valueOf(contentPromotionVideoId))
                .set(BANNERS_CONTENT_PROMOTION_VIDEO.PACKSHOT_HREF, packshotHref)
                .execute()
        );
    }
}
