package ru.yandex.autotests.direct.db.steps;

import java.util.List;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.DbqueueJobArchiveRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.DbqueueJobsRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.DBQUEUE_JOBS;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.DbqueueJobArchive.DBQUEUE_JOB_ARCHIVE;

/*
 * Степы для работы с таблицами dbqueue_jobs и dbqueue_job_archive
 */
public class DBQueueSteps extends BasePpcSteps {
    public static Long TYPE_BANNER_IMAGES = 4L;

    @Step("DB: получаем записи из dbqueue_job_archive для клиента {0}, тип {1}")
    public List<DbqueueJobArchiveRecord> getDbqueueJobArchiveRecords(Long clientId, Long jobTypeId) {
        return exec(db -> db.selectFrom(DBQUEUE_JOB_ARCHIVE)
                .where(DBQUEUE_JOB_ARCHIVE.CLIENTID.eq(clientId)
                        .and(DBQUEUE_JOB_ARCHIVE.JOB_TYPE_ID.eq(jobTypeId)))
                .fetch());
    }

    @Step("DB: удаляем записи из dbqueue_job_archive для клиента {0}, тип {1}")
    public void deleteDbqueueJobArchiveRecords(Long clientId, Long jobTypeId) {
        run(db -> db.deleteFrom(DBQUEUE_JOB_ARCHIVE)
                .where(DBQUEUE_JOB_ARCHIVE.CLIENTID.eq(clientId)
                        .and(DBQUEUE_JOB_ARCHIVE.JOB_TYPE_ID.eq(jobTypeId)))
                .execute());
    }

    @Step("DB: получаем записи из dbqueue_jobs для клиента {0}, тип {1}")
    public List<DbqueueJobsRecord> getDbqueueJobsRecords(Long clientId, Long jobTypeId) {
        return exec(db -> db.selectFrom(DBQUEUE_JOBS)
                .where(DBQUEUE_JOBS.CLIENTID.eq(clientId)
                        .and(DBQUEUE_JOBS.JOB_TYPE_ID.eq(jobTypeId)))
                .fetch());
    }
}
