package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.DEALS;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.enums.DealsDirectDealStatus.Active;

public class DealsSteps extends BasePpcSteps {

    @Step("DB: Добавление сделки {0} клиента {1} в таблицу DEALS")
    public void addDeal(Long dealId, Long clientId) {
        run(db -> db.insertInto(DEALS)
                .set(DEALS.CLIENTID, clientId)
                .set(DEALS.DEAL_ID, dealId)
                .set(DEALS.DIRECT_DEAL_STATUS, Active)
                .onDuplicateKeyIgnore()
                .execute()
        );
    }
}
