package ru.yandex.autotests.direct.db.steps;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.CLIENT_DIALOGS;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.CampDialogs.CAMP_DIALOGS;

@ParametersAreNonnullByDefault
public class DialogSteps extends BasePpcSteps {

    @Step("DB: удаление записей из таблицы ppc.camp_dialogs по ClientID")
    public void cleanCampaignDialogsOfClient(long clientId) {
        List<Long> clientDialogIdsForClientId = getClientDialogIdsForClientId(clientId);
        deleteCampaignDialogsByClientDialogIds(clientDialogIdsForClientId);
    }

    @Step("DB: удаление записей из таблицы ppc.camp_dialogs по clientDialogIds")
    public void deleteCampaignDialogsByClientDialogIds(List<Long> clientDialogIds) {
        run(db -> db
                .deleteFrom(CAMP_DIALOGS)
                .where(CAMP_DIALOGS.CLIENT_DIALOG_ID.in(clientDialogIds))
                .execute());
    }

    @Step("DB: удаление записи из таблицы ppc.camp_dialogs по cid")
    public void deleteCampaignDialogsByCid(long cid) {
        run(db -> db
                .deleteFrom(CAMP_DIALOGS)
                .where(CAMP_DIALOGS.CID.eq(cid))
                .execute());
    }

    @Step("DB: чтение client_dialog_id из таблицы ppc.client_dialogs по ClientID: {0}")
    public List<Long> getClientDialogIdsForClientId(long clientId) {
        return exec(db -> db.selectFrom(CAMP_DIALOGS)
                .where(CAMP_DIALOGS.CID.eq(clientId))
                .fetch(CAMP_DIALOGS.CLIENT_DIALOG_ID));
    }

    @Step("DB: удаление записи из таблицы ppc.client_dialogs по ClientID: {0}")
    public void deleteClientDialogs(long clientId) {
        run(db -> db
                .deleteFrom(CLIENT_DIALOGS)
                .where(CLIENT_DIALOGS.CLIENTID.eq(clientId))
                .execute());
    }
}
