package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.steps.base.CurrencyConvertQueueSteps;
import ru.yandex.autotests.direct.db.steps.base.DBStepsContext;
import ru.yandex.autotests.direct.utils.BaseSteps;
import ru.yandex.autotests.direct.utils.config.StageType;

/*
 * todo javadoc
 */
public class DirectJooqDbSteps {
    public static final String DIRECT_CONFIGURATION_DB_INFO = "/DirectConfiguration?keys=db_info";
    private DBStepsContext context;

    public DirectJooqDbSteps useShardForLogin(String login) {
        getContext().withCurrentPpcShard(shardingSteps().getShardByLogin(login));
        return this;
    }

    public DirectJooqDbSteps useShardForClientId(Long clientId) {
        getContext().withCurrentPpcShard(shardingSteps().getShardByClientID(clientId));
        return this;
    }

    public DirectJooqDbSteps useShard(int shard) {
        getContext().withCurrentPpcShard(shard);
        return this;
    }

    public int getCurrentPpcShard() {
        return getContext().getCurrentPpcShard();
    }

    public DirectJooqDbSteps() {
        context = new DBStepsContext();
        getContext().initConfig(context.getDirectIntapiJavaHost() + DIRECT_CONFIGURATION_DB_INFO);
    }

    public DirectJooqDbSteps(String host) {
        context = new DBStepsContext();
        getContext().initConfig(context.getDirectIntapiJavaHost(host) + DIRECT_CONFIGURATION_DB_INFO);
    }

    public DirectJooqDbSteps(StageType stageType, Integer betaPort) {
        context = new DBStepsContext();
        getContext().initConfig(context.getDirectIntapiJavaHost(stageType.url(betaPort)) + DIRECT_CONFIGURATION_DB_INFO);
    }

    public DBStepsContext getContext() {
        return context;
    }

    public SomeSteps someSteps() {
        return BaseSteps.getInstance(SomeSteps.class, getContext());
    }

    public TargetingCategoriesSteps interestSteps() {
        return BaseSteps.getInstance(TargetingCategoriesSteps.class, getContext());
    }

    public ShardingSteps shardingSteps() {
        return BaseSteps.getInstance(ShardingSteps.class, getContext());
    }

    public AdgroupsDynamicSteps adgroupsDynamicSteps() {
        return BaseSteps.getInstance(AdgroupsDynamicSteps.class, getContext());
    }

    public AdgroupsPerformanceSteps adgroupsPerformanceSteps() {
        return BaseSteps.getInstance(AdgroupsPerformanceSteps.class, getContext());
    }

    public AccountScoreSteps accountScoreSteps() {
        return BaseSteps.getInstance(AccountScoreSteps.class, getContext());
    }

    public CampaignsSteps campaignsSteps() {
        return BaseSteps.getInstance(CampaignsSteps.class, getContext());
    }

    public CampaignsInternalSteps campaignsInternalSteps() {
        return BaseSteps.getInstance(CampaignsInternalSteps.class, getContext());
    }

    public BillingAggregateSteps billingAggregateSteps() {
        return BaseSteps.getInstance(BillingAggregateSteps.class, getContext());
    }

    public BidsManualPricesSteps bidsManualPricesSteps() {
        return BaseSteps.getInstance(BidsManualPricesSteps.class, getContext());
    }

    public ProductsSteps productsSteps() {
        return BaseSteps.getInstance(ProductsSteps.class, getContext());
    }

    public IosSkAdNetworkSteps iosSkAdNetworkSteps() {
        return BaseSteps.getInstance(IosSkAdNetworkSteps.class, getContext());
    }

    public MulticurrencySteps multicurrencySteps() {
        return BaseSteps.getInstance(MulticurrencySteps.class, context);
    }

    public ClientsOptionsSteps clientsOptionsSteps() {
        return BaseSteps.getInstance(ClientsOptionsSteps.class, getContext());
    }

    public ClientLimitsSteps clientsLimitsSteps() {
        return BaseSteps.getInstance(ClientLimitsSteps.class, getContext());
    }

    public ClientsSteps clientsSteps() {
        return BaseSteps.getInstance(ClientsSteps.class, getContext());
    }

    public CreativesShardingSteps creativesShardingSteps() {
        return BaseSteps.getInstance(CreativesShardingSteps.class, getContext());
    }

    public PerfCreativesSteps perfCreativesSteps() {
        return BaseSteps.getInstance(PerfCreativesSteps.class, getContext());
    }

    public BannersPerformanceSteps bannersPerformanceSteps() {
        return BaseSteps.getInstance(BannersPerformanceSteps.class, getContext());
    }

    public FeedsSteps feedsSteps() {
        return BaseSteps.getInstance(FeedsSteps.class, getContext());
    }

    public FilteredFeedsSteps filteredFeedsSteps() {
        return BaseSteps.getInstance(FilteredFeedsSteps.class, getContext());
    }

    public AutopaySettingsSteps autopaySettingsSteps() {
        return BaseSteps.getInstance(AutopaySettingsSteps.class, getContext());

    }

    public MetrikaCountersSteps metrikaCountersSteps() {
        return BaseSteps.getInstance(MetrikaCountersSteps.class, getContext());
    }

    public BannerDisplayHrefsSteps bannerDisplayHrefsSteps() {
        return BaseSteps.getInstance(BannerDisplayHrefsSteps.class, getContext());
    }

    public BannerTurboGalleriesSteps bannerTurboGalleriesSteps() {
        return BaseSteps.getInstance(BannerTurboGalleriesSteps.class, getContext());
    }

    public PpcPropertiesSteps ppcPropertiesSteps() {
        return BaseSteps.getInstance(PpcPropertiesSteps.class, getContext());
    }

    public WalletPaymentTransactionsSteps walletPaymentTransactionsSteps() {
        return BaseSteps.getInstance(WalletPaymentTransactionsSteps.class, getContext());
    }

    public WalletCampaignsSteps walletCampaignsSteps() {
        return BaseSteps.getInstance(WalletCampaignsSteps.class, getContext());
    }

    public BannerImagesPoolSteps bannerImagesPoolSteps() {
        return BaseSteps.getInstance(BannerImagesPoolSteps.class, getContext());
    }

    public UsersOptionsSteps usersOptionsSteps() {
        return BaseSteps.getInstance(UsersOptionsSteps.class, getContext());
    }

    public UsersApiOptionsSteps usersApiOptionsSteps() {
        return BaseSteps.getInstance(UsersApiOptionsSteps.class, getContext());
    }

    public MirrorsSteps mirrorsSteps() {
        return BaseSteps.getInstance(MirrorsSteps.class, getContext());
    }

    public ApiDomainStatSteps apiDomainStatSteps() {
        return BaseSteps.getInstance(ApiDomainStatSteps.class, getContext());
    }

    public ClientsToForceMulticurrencyTeaserSteps clientsToForceMulticurrencyTeaser() {
        return BaseSteps.getInstance(ClientsToForceMulticurrencyTeaserSteps.class, getContext());
    }


    public ForceCurrencyConvertSteps forceCurrencyConvertSteps() {
        return BaseSteps.getInstance(ForceCurrencyConvertSteps.class, getContext());
    }

    public CurrencyConvertQueueSteps currencyConvertQueueSteps() {
        return BaseSteps.getInstance(CurrencyConvertQueueSteps.class, getContext());
    }

    public ClientTeaserDataLastupdateSteps clientTeaserDataLastupdateSteps() {
        return BaseSteps.getInstance(ClientTeaserDataLastupdateSteps.class, getContext());
    }

    public BidsPerformanceSteps bidsPerformanceSteps() {
        return BaseSteps.getInstance(BidsPerformanceSteps.class, getContext());
    }

    public BidsRetargetingSteps bidsRetargetingSteps() {
        return BaseSteps.getInstance(BidsRetargetingSteps.class, getContext());
    }

    public BidsDynamicSteps bidsDynamicSteps() {
        return BaseSteps.getInstance(BidsDynamicSteps.class, getContext());
    }

    public BidsSteps bidsSteps() {
        return BaseSteps.getInstance(BidsSteps.class, getContext());
    }

    public DomainsSteps domainsSteps() {
        return BaseSteps.getInstance(DomainsSteps.class, getContext());
    }

    public DomainsDictSteps domainsDictSteps() {
        return BaseSteps.getInstance(DomainsDictSteps.class, getContext());
    }

    public MarketRatingsSteps marketRatingsSteps() {
        return BaseSteps.getInstance(MarketRatingsSteps.class, getContext());
    }

    public AddressesSteps addressesSteps() {
        return BaseSteps.getInstance(AddressesSteps.class, getContext());
    }

    public VCardSteps vCardSteps() {
        return BaseSteps.getInstance(VCardSteps.class, getContext());
    }

    public OrganizationsSteps organizationsSteps() {
        return BaseSteps.getInstance(OrganizationsSteps.class, getContext());
    }

    public ImagesSteps imagesSteps() {
        return BaseSteps.getInstance(ImagesSteps.class, getContext());
    }

    public InfoblockTeasersFactorsSteps infoblockTeasersFactorsSteps() {
        return BaseSteps.getInstance(InfoblockTeasersFactorsSteps.class, getContext());
    }

    public ExperimentsSteps experimentsSteps() {
        return BaseSteps.getInstance(ExperimentsSteps.class, getContext());
    }

    public BannersSteps bannersSteps() {
        return BaseSteps.getInstance(BannersSteps.class, getContext());
    }

    public BannersInternalSteps bannersInternalSteps() {
        return BaseSteps.getInstance(BannersInternalSteps.class, getContext());
    }

    public ApiFinanceTokensSteps apiFinanceTokensSteps() {
        return BaseSteps.getInstance(ApiFinanceTokensSteps.class, getContext());
    }

    public BannerPricesSteps bannerPricesSteps() {
        return BaseSteps.getInstance(BannerPricesSteps.class, getContext());
    }

    public ContentPromotionVideoSteps contentPromotionVideoSteps() {
        return BaseSteps.getInstance(ContentPromotionVideoSteps.class, getContext());
    }

    public BannersContentPromotionVideoSteps bannersContentPromotionVideoSteps() {
        return BaseSteps.getInstance(BannersContentPromotionVideoSteps.class, getContext());
    }

    public BannersContentPromotionSteps bannersContentPromotionSteps() {
        return BaseSteps.getInstance(BannersContentPromotionSteps.class, getContext());
    }

    public ContentPromotionSteps contentPromotionSteps() {
        return BaseSteps.getInstance(ContentPromotionSteps.class, getContext());
    }

    public HyperGeoSteps hyperGeoSteps() {
        return BaseSteps.getInstance(HyperGeoSteps.class, getContext());
    }

    public RetargetingConditionSteps retargetingConditionSteps() {
        return BaseSteps.getInstance(RetargetingConditionSteps.class, getContext());
    }

    public AdGroupsSteps adGroupsSteps() {
        return BaseSteps.getInstance(AdGroupsSteps.class, getContext());
    }

    public AdGroupsTextSteps adGroupsTextSteps() {
        return BaseSteps.getInstance(AdGroupsTextSteps.class, getContext());
    }

    public AdGroupsInternalSteps adGroupsInternalSteps() {
        return BaseSteps.getInstance(AdGroupsInternalSteps.class, getContext());
    }

    public AdGroupsContentPromotionSteps adGroupsContentPromotionSteps() {
        return BaseSteps.getInstance(AdGroupsContentPromotionSteps.class, getContext());
    }


    public BsDeadDomainsSteps bsDeadDomainsSteps() {
        return BaseSteps.getInstance(BsDeadDomainsSteps.class, getContext());
    }

    public ModerationSteps moderationSteps() {
        return BaseSteps.getInstance(ModerationSteps.class, getContext());
    }

    public ShowDiagSteps showDiagSteps() {
        return BaseSteps.getInstance(ShowDiagSteps.class, getContext());
    }

    public UsersSteps usersSteps() {
        return BaseSteps.getInstance(UsersSteps.class, getContext());
    }

    public DBQueueSteps dbqueueSteps() {
        return BaseSteps.getInstance(DBQueueSteps.class, getContext());
    }

    public SspPlatformsSteps sspPlatformsSteps() {
        return BaseSteps.getInstance(SspPlatformsSteps.class, getContext());
    }

    public MinusWordsSteps minusWordsSteps() {
        return BaseSteps.getInstance(MinusWordsSteps.class, getContext());
    }

    public MobileAppSteps mobileAppsSteps() {
        return BaseSteps.getInstance(MobileAppSteps.class, getContext());
    }

    public MobileContentSteps mobileContentSteps() {
        return BaseSteps.getInstance(MobileContentSteps.class, getContext());
    }

    public ModReasonsSteps modReasonsSteps() {
        return BaseSteps.getInstance(ModReasonsSteps.class, getContext());
    }

    public ModEditSteps modEditSteps() {
        return BaseSteps.getInstance(ModEditSteps.class, getContext());
    }

    public AgencyClientRelationsSteps agencyClientRelationsSteps() {
        return BaseSteps.getInstance(AgencyClientRelationsSteps.class, getContext());
    }

    public AgencyClientProveSteps agencyClientProveSteps() {
        return BaseSteps.getInstance(AgencyClientProveSteps.class, getContext());
    }

    public TransportSteps transportSteps() {
        return BaseSteps.getInstance(TransportSteps.class, getContext());
    }

    public SitelinksSteps sitelinksSteps() {
        return BaseSteps.getInstance(SitelinksSteps.class, getContext());
    }

    public BannerAdditionsSteps bannerAdditionsSteps() {
        return BaseSteps.getInstance(BannerAdditionsSteps.class, getContext());
    }

    public AdGroupBsTagsSteps adGroupBsTagsSteps() {
        return BaseSteps.getInstance(AdGroupBsTagsSteps.class, getContext());
    }

    public RetargetingGoalsSteps retargetingGoalsSteps() {
        return BaseSteps.getInstance(RetargetingGoalsSteps.class, getContext());
    }

    public MediaResourcesSteps mediaResourcesSteps() {
        return BaseSteps.getInstance(MediaResourcesSteps.class, getContext());
    }

    public BannerResourcesSteps bannerResourcesSteps() {
        return BaseSteps.getInstance(BannerResourcesSteps.class, getContext());
    }

    public BidsBaseSteps bidsBaseSteps() {
        return BaseSteps.getInstance(BidsBaseSteps.class, getContext());
    }

    public MultipliersSteps multipliersSteps() {
        return BaseSteps.getInstance(MultipliersSteps.class, getContext());
    }

    public CampMetrikaGoalsSteps campMetrikaGoalsSteps() {
        return BaseSteps.getInstance(CampMetrikaGoalsSteps.class, getContext());
    }

    public CampTurbolandingsMetricaCountersSteps campTurbolandingsMetricaCountersSteps() {
        return BaseSteps.getInstance(CampTurbolandingsMetricaCountersSteps.class, getContext());
    }

    public CampStopStatSteps campStopStatSteps() {
        return BaseSteps.getInstance(CampStopStatSteps.class, getContext());
    }

    public CampAggregatedLastChangeSteps campAggregatedLastChangeSteps() {
        return BaseSteps.getInstance(CampAggregatedLastChangeSteps.class, getContext());
    }

    public OptimizingCampaignRequestsSteps optimizingCampaignRequestsSteps() {
        return BaseSteps.getInstance(OptimizingCampaignRequestsSteps.class, getContext());
    }

    public PhrasesStatSteps phrasesStatSteps() {
        return BaseSteps.getInstance(PhrasesStatSteps.class, getContext());
    }

    public BsResyncQueueSteps bsResyncQueueSteps() {
        return BaseSteps.getInstance(BsResyncQueueSteps.class, getContext());
    }

    public BsExportQueueSteps bsExportQueueSteps() {
        return BaseSteps.getInstance(BsExportQueueSteps.class, getContext());
    }

    public MetrikaGoalsSteps metrikaGoalsSteps() {
        return BaseSteps.getInstance(MetrikaGoalsSteps.class, getContext());
    }

    public TrustedRedirectsSteps trustedRedirectsSteps() {
        return BaseSteps.getInstance(TrustedRedirectsSteps.class, getContext());
    }

    public ClientBrandsSteps clientBrandsSteps() {
        return BaseSteps.getInstance(ClientBrandsSteps.class, getContext());
    }

    public ClientsCustomOptionsSteps clientCustomOptionsSteps() {
        return BaseSteps.getInstance(ClientsCustomOptionsSteps.class, getContext());
    }

    public ClientReminderLettersSteps clientReminderLetters() {
        return BaseSteps.getInstance(ClientReminderLettersSteps.class, getContext());
    }

    public InternalAdProductSteps internalAdProductSteps() {
        return BaseSteps.getInstance(InternalAdProductSteps.class, getContext());
    }

    public StrategyChangeLogSteps strategyChangeLogSteps() {
        return BaseSteps.getInstance(StrategyChangeLogSteps.class, getContext());
    }

    public ClientsApiOptionsSteps clientsApiOptionsSteps() {
        return BaseSteps.getInstance(ClientsApiOptionsSteps.class, getContext());
    }

    public YandexAgencyOrdersSteps yandexAgencyOrdersSteps() {
        return BaseSteps.getInstance(YandexAgencyOrdersSteps.class, getContext());
    }

    public AutoBudgetCpaAlertsSteps autoBudgetCpaAlertsSteps() {
        return BaseSteps.getInstance(AutoBudgetCpaAlertsSteps.class, getContext());
    }

    public AutoBudgetAlertsSteps autoBudgetAlertsSteps() {
        return BaseSteps.getInstance(AutoBudgetAlertsSteps.class, getContext());
    }

    public EventLogSteps eventLogSteps() {
        return BaseSteps.getInstance(EventLogSteps.class, getContext());
    }

    public TurboLandingsSteps turboLandingsSteps() {
        return BaseSteps.getInstance(TurboLandingsSteps.class, getContext());
    }

    public AgencyOptionsSteps agencyOptionsSteps() {
        return BaseSteps.getInstance(AgencyOptionsSteps.class, getContext());
    }

    public PixelsSteps pixelsSteps() {
        return BaseSteps.getInstance(PixelsSteps.class, getContext());
    }

    public CampOperationsQueueCopySteps campOperationsQueueCopySteps() {
        return BaseSteps.getInstance(CampOperationsQueueCopySteps.class, getContext());
    }

    public CampOperationsQueueSteps campOperationsQueueSteps() {
        return BaseSteps.getInstance(CampOperationsQueueSteps.class, getContext());
    }

    public AdfoxSteps adfoxSteps() {
        return BaseSteps.getInstance(AdfoxSteps.class, getContext());
    }

    public CampaignDealsSteps campaignDealsSteps() {
        return BaseSteps.getInstance(CampaignDealsSteps.class, context);
    }

    public CryptaGoalsSteps cryptaGoalsSteps() {
        return BaseSteps.getInstance(CryptaGoalsSteps.class, getContext());
    }

    public LalSegmentsSteps lalSegmentsSteps() {
        return BaseSteps.getInstance(LalSegmentsSteps.class, getContext());
    }

    public BannerTurbolandingsSteps bannerTurbolandingsSteps() {
        return BaseSteps.getInstance(BannerTurbolandingsSteps.class, getContext());
    }

    public FeaturesSteps featuresSteps() {
        return BaseSteps.getInstance(FeaturesSteps.class, getContext());
    }

    public FreelancerProjectSteps freelancerProjectSteps() {
        return BaseSteps.getInstance(FreelancerProjectSteps.class, getContext());
    }

    public FreelancerCardSteps freelancerCardSteps() {
        return BaseSteps.getInstance(FreelancerCardSteps.class, getContext());
    }

    public DealsSteps dealsSteps() {
        return BaseSteps.getInstance(DealsSteps.class, context);
    }

    public DialogSteps dialogSteps() {
        return BaseSteps.getInstance(DialogSteps.class, context);
    }

    public PlacementsSteps placementsSteps() {
        return BaseSteps.getInstance(PlacementsSteps.class, context);
    }

    public ClientPixelProvidersSteps clientPixelProvidersSteps() {
        return BaseSteps.getInstance(ClientPixelProvidersSteps.class, context);
    }

    public MysqlStateSteps mysqlStateSteps() {
        return BaseSteps.getInstance(MysqlStateSteps.class, context);
    }

    public DynamicConditionsSteps dynamicConditionsSteps() {
        return BaseSteps.getInstance(DynamicConditionsSteps.class, context);
    }

    public TemplateResourceSteps templateResourceSteps() {
        return BaseSteps.getInstance(TemplateResourceSteps.class, context);
    }

    public DirectTemplateSteps directTemplateSteps() {
        return BaseSteps.getInstance(DirectTemplateSteps.class, context);
    }

    public BadDomainsTitlesSteps badDomainsTitlesSteps() {
        return BaseSteps.getInstance(BadDomainsTitlesSteps.class, getContext());
    }

    public BannerMeasurerSteps bannerMeasurerSteps() {
        return BaseSteps.getInstance(BannerMeasurerSteps.class, getContext());
    }

    public BannerAdditionalHrefSteps bannerAdditionalHrefSteps() {
        return BaseSteps.getInstance(BannerAdditionalHrefSteps.class, getContext());
    }

    public CampaignsPromotionsSteps campaignsPromotionsSteps() {
        return BaseSteps.getInstance(CampaignsPromotionsSteps.class, getContext());
    }

    public StrategiesSteps strategiesSteps() {
        return BaseSteps.getInstance(StrategiesSteps.class, getContext());
    }

    public StrategyMetrikaCountersSteps strategyMetrikaCountersSteps() {
        return BaseSteps.getInstance(StrategyMetrikaCountersSteps.class, getContext());
    }

    public PricePackagesSteps pricePackagesSteps() {
        return BaseSteps.getInstance(PricePackagesSteps.class, getContext());
    }

}
