package ru.yandex.autotests.direct.db.steps;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.autotests.direct.db.models.jooq.ppcdict.enums.DirectTemplateState;
import ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.records.DirectTemplateResourceRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcDictSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppcdict.Tables.DIRECT_TEMPLATE;
import static ru.yandex.autotests.direct.db.models.jooq.ppcdict.Tables.DIRECT_TEMPLATE_RESOURCE;

@ParametersAreNonnullByDefault
public class DirectTemplateSteps extends BasePpcDictSteps {

    @Step("DB: обновление способа отправки в БК шаблона id:{0} на {1}")
    public void updateDirectTemplateState(long templateId, DirectTemplateState state) {
        exec(db -> db.update(DIRECT_TEMPLATE)
                .set(DIRECT_TEMPLATE.STATE, state)
                .where(DIRECT_TEMPLATE.DIRECT_TEMPLATE_ID.eq(templateId))
                .execute());
    }

    @Step("DB: чтение формата шаблона id:{0}")
    public String getDirectTemplateFormat(long templateId) {
        return exec(db -> db.select(DIRECT_TEMPLATE.FORMAT_NAME)
                .from(DIRECT_TEMPLATE)
                .where(DIRECT_TEMPLATE.DIRECT_TEMPLATE_ID.eq(templateId))
                .fetchOne(DIRECT_TEMPLATE.FORMAT_NAME));
    }

    @Step("DB: добавление ресурса с номером {1} в шаблон id:{0} при его отсутствии")
    public DirectTemplateResourceRecord addOrGetDirectTemplateResource(long templateId, short resourceNo,
               short unifiedResourceNo, long unifiedTemplateResourceId, String options) {
        DirectTemplateResourceRecord existingId = exec(db -> db.selectFrom(DIRECT_TEMPLATE_RESOURCE)
                .where(DIRECT_TEMPLATE_RESOURCE.DIRECT_TEMPLATE_ID.eq(templateId)
                        .and(DIRECT_TEMPLATE_RESOURCE.RESOURCE_NO.eq(resourceNo)))
                .fetchOne()
        );
        if (existingId != null) {
            return existingId;
        }
        return exec(db -> db.insertInto(DIRECT_TEMPLATE_RESOURCE)
                .columns(DIRECT_TEMPLATE_RESOURCE.DIRECT_TEMPLATE_ID,
                        DIRECT_TEMPLATE_RESOURCE.RESOURCE_NO,
                        DIRECT_TEMPLATE_RESOURCE.UNIFIED_RESOURCE_NO,
                        DIRECT_TEMPLATE_RESOURCE.UNIFIED_TEMPLATE_RESOURCE_ID,
                        DIRECT_TEMPLATE_RESOURCE.OPTIONS)
                .values(templateId,
                        resourceNo,
                        unifiedResourceNo,
                        unifiedTemplateResourceId,
                        options)
                .returning()
                .fetchOne()
        );
    }
}
