package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.records.DomainsDictRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcDictSteps;
import ru.yandex.qatools.allure.annotations.Step;

import java.util.List;

import static ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.DomainsDict.DOMAINS_DICT;

/**
 * Created by pashkus on 22.06.16.
 */
public class DomainsDictSteps extends BasePpcDictSteps {

    @Step("DB: получение записи из ppcdict.domains_dict для domain = {0}")
    public DomainsDictRecord getDomainsDictRecord(String domain) {
        return exec(db ->
                db.selectFrom(DOMAINS_DICT)
                        .where(DOMAINS_DICT.DOMAIN.eq(domain))
                        .fetchOne());
    }

    @Step("DB: получение записи из ppcdict.domains_dict для domainId = {0}")
    public DomainsDictRecord getDomainsDictRecord(Long domainId) {
        return exec(db ->
                db.selectFrom(DOMAINS_DICT)
                        .where(DOMAINS_DICT.DOMAIN_ID.eq(domainId))
                        .fetchOne());
    }

    @Step("DB: получение domainId из ppcdict.domains_dict для domain = {0}")
    public Long getDomainId(String domain) {
        DomainsDictRecord record = exec(db ->
                db.selectFrom(DOMAINS_DICT)
                        .where(DOMAINS_DICT.DOMAIN.eq(domain))
                        .fetchOne());
        return record != null ? record.getDomainId() : null;
    }

    @Step("DB: получение списка domainId из ppcdict.domains_dict для domain = {0}")
    public List<Long> getDomainId(String... domains) {
        return exec(db ->
                db.selectFrom(DOMAINS_DICT)
                        .where(DOMAINS_DICT.DOMAIN.in(domains))
                        .fetch()
                        .getValues(DOMAINS_DICT.DOMAIN_ID));
    }

    @Step("DB: запись в таблицу ppcdict.domains_dict")
    public DomainsDictRecord createDomain(DomainsDictRecord domain) {
        return exec(db ->
                db.insertInto(DOMAINS_DICT)
                        .set(domain).returning()
                        .fetchOne());
    }

    @Step("DB: удаление из таблицы ppcdict.domains_dict")
    public void deleteDomain(Long... ids) {
        exec(db ->
                db.deleteFrom(DOMAINS_DICT)
                        .where(DOMAINS_DICT.DOMAIN_ID.in(ids))
                        .execute());
    }


}
